/*************************************************************
 * File: include/time.h
 * Purpose: Header file for time functions.
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	981012	Created
 *	981220	Decl for ctime, localtime and gmtime fixed.
 */

#ifndef _TIME_H_
#define _TIME_H_


typedef unsigned long time_t;

struct tm {
	int tm_sec; /* seconds (0-59) */
	int tm_min; /* minutes (0-59) */
	int tm_hour; /* hours (0-23) */
	int tm_mday; /* day of month (1-31) */
	int tm_mon;  /* month of year (0-11) */
	int tm_year; /* year - 1900 */
	int tm_wday; /* day of week (Sunday=0) */
	int tm_yday; /* day of year (0-365) */
	int tm_isdst; /* daylight savings in effect */
	};

time_t time(time_t *timer);
int stime(time_t *timer);
char *ctime(time_t *clock);
struct tm *localtime(time_t *clock);
struct tm *gmtime(time_t *clock);
char *asctime(struct tm *ts);
time_t mktime(int yr,int mon,int day,int hr,int min);

#endif
