/*************************************************************
 * File: include/terms.h
 * Purpose: Part of the PMON source package
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	980409	Start of revision history
 *	980409	Added 90084 stuff
 *	980409	Include utypes.h
 *	980618	Added beoffs and gap to p2681info.o
 */

#ifndef _TERMS_
#define _TERMS_

#define OP_INIT 1
#define OP_TX 2
#define OP_RX 3
#define OP_RXRDY 4
#define OP_TXRDY 5
#define OP_BAUD 6
#define OP_CLKINIT 7
#define OP_DELAY 8
#define OP_BAUDRATES 9

#ifdef LANGUAGE_C
#include <utypes.h>
typedef unsigned char byte;

struct p8530info {
	byte *siobase;
	byte wr3[2];
	byte wr5[2];
	} ;

struct sableinfo {
	byte *siobase;
	} ;

typedef struct L90084rec {
	Ulong sod;	/* 32-bit rw */
	Ulong soc; 	/* 32-bit rw */
	Ulong sid;	/* 32-bit rw */
	Ulong sic; 	/* 32-bit rw */
	Ulong baud;	/* 32-bit rw */
	} L90084rec;

extern L90084rec l0084_sio[];

struct p16550Rec {
	Ulong base;
	int beoffs;
	int gap;
	int baudclk;
	};

struct pttyRec {
	Ulong hr;
	Ulong sr;
	};

struct pttyinfo {
	Ulong siobase;
	struct pttyRec *tx;
	struct pttyRec *rx;
	} ;

struct p2681info {
	Ulong siobase;
	int beoffs;
	int gap;
	byte brate[2];
	byte curacr;
	} ;

struct iceportinfo {
	Ulong siobase;
	} ;

typedef struct L8251rec {
	Ulong attribute; 	/* 32-bit rw */
	Ulong mode;		/* 16-bit wo */
	Ulong baudrate; 	/* 16-bit wo */
	Ulong data;		/* 8-bit rw */
	Ulong cmd;		/* 8-bit wo */
	Ulong status;		/* 8-bit ro */
	} L8251rec;

extern L8251rec l08_sio[];

struct p8251info {
	Uchar *siobase;
	} ;

struct p16c552info {
	Uchar *siobase;
	};

struct ps2struct {
	int led_state;
	int sh_state;
	int ctrl_state;
	int curx;
	int cury;
	int rxbuf;
	int prev;
	};
#endif


#endif /* _TERMS_ */
