/*************************************************************
 * File: include/termio.h
 * Purpose: defines for terminal I/O operations
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970826	Start of revision history
 *	980618	Added baudrates 57600..921600
 */

#if !defined(_TERMIO_) && !defined(NCC)
#define _TERMIO_

#define FILEOFFSET	200	/* all files start at fd=200 */
#define ETHERFD		(FILEOFFSET-1)	/* special fd value for ethernet */

/* operation codes for ioctl */
#define TCGETA 1
#define TCSETAF 2
#define TCSETAW 3
#define SETINTR 4
#define SETSANE 5
#define FIONREAD 6
#define GETINTR 7
#define GETTERM 8
#define SETTERM 9
#define SETNCNE 10
#define CBREAK 11
#define TERMTYPE 12
#define DEVENTRY 13
#define TXRDY 14
#define SETICEE 15
#define BAUDRATES 16

/* iflags */
#define ISTRIP 0x0020
#define ICRNL  0x0040
#define IXON   0x0400
#define IXANY  0x0800
#define IXOFF  0x1000

/* oflags */
#define ONLCR  0x0004

/* lflags */
#define ICANON 0x0002
#define ECHO   0x0008
#define ECHOE  0x0010

/* cflags */
#define	CBAUD	0000037
#define	B0	0
#define	B50	0000001	
#define	B75	0000002
#define	B110	0000003
#define	B134	0000004
#define	B150	0000005
#define	B200	0000006
#define	B300	0000007
#define	B600	0000010
#define	B1200	0000011
#define	B1800	0000012
#define	B2400	0000013
#define	B4800	0000014
#define	B9600	0000015
#define	B19200	0000016
#define	B38400	0000017
#define	B57600	0000020
#define	B76800	0000021
#define	B115200	0000022
#define	B153600	0000023
#define	B230400	0000024
#define	B307200	0000025
#define	B460800	0000026
#define	B921600	0000027

/* cc definitions */
#define VINTR 		0
#define VQUIT 		1
#define VERASE 		2
#define VKILL		3
#define VEOF		4
#define VMIN		VEOF
#define VEOL 		5
#define VTIME		VEOL
#define VEOL2 		6
#define VSWTCH		7
#define VSTART 		8
#define VSTOP 		9

/* maintain for backward compatability */
#define V_START 8
#define V_STOP 9

#define DEV_MAX 8
#ifndef STDIN
#define STDIN 0
#endif
#define STDOUT 1
#define STDERR 2

/* operation codes for ttctl */
#define TT_CM 1		/* cursor movement */
#define TT_CLR 2	/* clear screen */
#define TT_CUROFF 3	/* switch cursor off */
#define TT_CURON 4	/* switch cursor on */

#ifdef LANGUAGE_C
#ifndef CNTRL
#define CNTRL(x) (x & 0x1f)
#endif

#ifdef PMCC
#define NCC 23
struct termio {
	unsigned short c_iflag;
	unsigned short c_oflag;
	unsigned short c_cflag;
	unsigned short c_lflag;
	unsigned char c_cc[NCC];
	};
#endif

#include <stdio.h>

typedef struct ConfigEntry { /*
 * Defines an entry in the ConfigTable located in pmon/devinfo.c.
 * Note that pmon only calls the driver's INIT function for entries
 * that have chan=0.  The devinfo structure is the only way for the
 * driver to have static data that is device specific. */ 
	Addr devinfo;	/* addr of struct containing device address etc */
	int chan;	/* channel#. Used for DUARTS */
	Func *handler;	/* addr of driver */
	int rxqsize;	/* size of receive buffer */
	int brate;	/* default baudrate */
	} ConfigEntry;

#include "mips.h"
#include "queue.h"
#include <setjmp.h>

typedef struct DevEntry {
	int txoff;
	int qsize;
	Queue *rxq;
	Addr sio;
	int chan;
	int rxoff;
	int pollin;
	int fifoenabled;
	Func *handler;
	jmp_buf *intr;
	char *tname;
	Func *tfunc;
	struct termio t;
	} DevEntry;

typedef struct File {
	int dev;
	int valid;
	} File;

typedef struct Ramfile {
	char *name;
	int open;
	unsigned long base;
	unsigned long size;
	unsigned long posn;
	} Ramfile;

/* this is needed when building imon95 */
#ifndef OPEN_MAX
#define OPEN_MAX 10
#endif

extern DevEntry DevTable[DEV_MAX];
extern File _file[OPEN_MAX];
extern Ramfile _mfile[];
extern int *curlst;
extern int re_ether;

#endif /* LANGUAGE_C */

#endif /* _TERMIO_ */

