/*************************************************************
 * File: include/lr64388.h
 * Purpose: Header file for 64388 (RAP)
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	980701	Created
 */

#if defined(LR64388) && !defined(_LR64388_)
#define _LR64388_

/* The 64388 is based on the 4011 core (which is really an updated 4011) */
#ifndef LR4010
#define LR4010
#endif
#include "lr4010.h"


#define M_RAP_AddrMap   0xb0008400


#ifdef LANGUAGE_ASSEMBLY

#if 0
#ifdef ALGOR
#define flush_icache 	.set nowarn; \
			.word	0xbc010000;\
			.set warn; 42:
#define flush_dcache	.set nowarn; \
			.word	0xbc020000; \
			.set warn; 42:
#define wb_dcache(a,b)	.set nowarn; \
			.word	(0xbc040000|((b)<<21)|((a)&0xffff)); \
			.set warn; 42:
#else

#define flush_icache 	.word	0xbc010000	# flush the Icache
#define flush_dcache	.word	0xbc020000	# flush the Dcache
			/* write-back Dcache line */
#define wb_dcache(a,b)	.word	(0xbc040000|((b)<<21)|((a)&0xffff))	

#endif /* ALGOR */
#endif

#define C0_INDEX	$0		/* index (mmu) */
#define C0_INX		$0		/* index (mmu) */
#define C0_RANDOM	$1		/* random (mmu) */
#define C0_RAND		$1		/* random (mmu) */
#define C0_ENTRYLO	$2		/* entry lo (mmu) */
#define C0_TLBLO	$2		/* entry lo (mmu) */
#define C0_CONTEXT	$4		/* context (mmu) */
#define C0_CTEXT	$4		/* context (mmu) */
#define C0_PAGEMASK	$5		/* pagemask */
#define C0_WIRED	$6		/* wired (mmu) */
#define C0_DCS		$7		/* debug and cache cntl */
#define C0_BADVA	$8		/* bad virtual address */
#define C0_COUNT	$9		/* count */
#define C0_ENTRYHI	$10		/* entry hi (mmu) */
#define C0_TLBHI	$10		/* entry hi (mmu) */
#define C0_COMPARE	$11		/* compare */
#define C0_CCC		$16		/* config */
#define C0_LLADR	$17		/* Load linked Adrs */
#define C0_ROTATE	$23		/* for selsr/selsl instrs */
#define C0_CMASK	$24		/* for addciu instr */
#define C0_ERREPC	$30		/* ErrorEpc */
#endif
#ifdef LANGUAGE_C
#define C0_INDEX	0		/* index (mmu) */
#define C0_INX		0		/* index (mmu) */
#define C0_RANDOM	1		/* random (mmu) */
#define C0_RAND		1		/* random (mmu) */
#define C0_ENTRYLO	2		/* entry lo (mmu) */
#define C0_TLBLO	2		/* entry lo (mmu) */
#define C0_CONTEXT	4		/* context (mmu) */
#define C0_CTEXT	4		/* context (mmu) */
#define C0_PAGEMASK	5		/* pagemask (mmu) */
#define C0_WIRED	6		/* wired (mmu) */
#define C0_DCS		7		/* debug and cache cntl */
#define C0_BADVA	8		/* bad virtual address */
#define C0_COUNT	9		/* count */
#define C0_ENTRYHI	10		/* entry hi (mmu) */
#define C0_TLBHI	10		/* entry hi (mmu) */
#define C0_COMPARE	11		/* compare */
#define C0_CCC		16		/* config */
#define C0_LLADR	17		/* Load linked Adrs */
#define C0_ROTATE	23		/* for selsr/selsl instrs */
#define C0_CMASK	24		/* for addciu instr */
#define C0_ERREPC	30		/* ErrorEpc */
#endif


/* CCC register in cp0 */
#define CCC_ISR1	(1<<26)		/* scratchpad ram enable I$ set 1 */
#define CCC_EVI		(1<<25)		/* external vectored int enable */
#define CCC_CMP		(1<<24)		/* R3000 compatibility mode */
#define CCC_IIE		(1<<23)		/* I-cache invalidate enable */
#define CCC_DIE		(1<<22)		/* D-cache invalidate enable */
#define CCC_MUL		(1<<21)		/* hardware multiplier enable */
#define CCC_MAD		(1<<20)		/* multiplier supports accum */
#define CCC_TMR		(1<<19)		/* timer enable --> IP7 */
#define CCC_BGE		(1<<18)		/* bus grant enable */
#define CCC_IE0		(1<<17)		/* I-cache enable set 0 */
#define CCC_IE1		(1<<16)		/* I-cache enable set 1 */
#define CCC_IS		(3<<14)		/* I-cache set size (1K,2K,4K,8K) */
#define CCC_IS1		(0<<14)		/* I-cache set size 1K */
#define CCC_IS2		(1<<14)		/* I-cache set size 2K */
#define CCC_IS4		(2<<14)		/* I-cache set size 4K */
#define CCC_IS8		(3<<14)		/* I-cache set size 8K */
#define CCC_ISSHIFT	14
#define CCC_ISSHFT	14
#define CCC_ISMASK	(3<<14)
#define CCC_DE0		(1<<13)		/* D-cache enable set 0 */
#define CCC_DE1		(1<<12)		/* D-cache enable set 1 */
#define CCC_DS		(3<<10)		/* D-cache set size (1K,2K,4K,8K) */
#define CCC_DS1		(0<<10)		/* D-cache set size 1K */
#define CCC_DS2		(1<<10)		/* D-cache set size 2K */
#define CCC_DS4		(2<<10)		/* D-cache set size 4K */
#define CCC_DS8		(3<<10)		/* D-cache set size 8K */
#define CCC_DSSHIFT	10
#define CCC_DSSHFT	10
#define CCC_DSMASK	(3<<10)
#define CCC_IPWE	(1<<9)		/* In page write enable */
#define CCC_IPWS	(3<<7)		/* In page write size (1K,2K,4K,8K) */
#define CCC_TE		(1<<6)		/* TLB enable */
#define CCC_WB		(1<<5)		/* use writeback for non tlb mapped */
#define CCC_SR0		(1<<4)		/* scratchpad ram enable D$ set 0 */
#define CCC_SR1		(1<<3)		/* scratchpad ram enable D$ set 1 */
#define CCC_ISC		(1<<2)		/* isolate cache mode */
#define CCC_TAG		(1<<1)		/* tag test mode */
#define CCC_INV		(1<<0)		/* cache invalidate mode */


/* Here are some alternate names */
#ifdef LANGUAGE_C
#define C0_ENTLO_0    2
#define C0_ENTLO_1    3
#define C0_PGMASK     5
#define C0_ENTHI      10
#endif

#define SR_KSU        (3<<3)
#define SR_UMODE      (2<<3)
#define SR_EXL        (1<<1)


#endif /* _LR64388_ */
