/*************************************************************
 * File: include/lr64364.h
 * Purpose: header file for 64364
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	980624	Created
 */

#if defined(LR64364) && !defined(_LR64364_H_)
#define _LR64364_H_
/* The ATMizer-II+ (64364) is basically the same as the 64363.
 * It has a few different values in a64364.s, and the 2681 DUART is
 * connected to the hi-order data bits of the bus. This means that
 * you don't add 3 to the base address for MIPSEB. It also uses the
 * 4011, rather than the 4010 core.
 */
#ifndef LR64363
#define LR64363
#endif
#ifndef LR4010
#define LR4010
#endif

#include "dbxcore.h"
#include "lr4010.h"

#define APU_BASE	0xb8000300
#define M_APU_AddrMap		(APU_BASE+0x00) /* address map register */
#define M_APU_Watchdog		(APU_BASE+0x06) /* */
#define M_APU_SRL		(APU_BASE+0x08) /* */
#define M_APU_VIntEnable	(APU_BASE+0x0e) /* */
#define M_APU_VIntBase		(APU_BASE+0x10) /* */
#define M_APU_Status		(APU_BASE+0x14) /* */

#define ADRM_RESET		(1<<31)
#define ADRM_BOOT_MASK		(3<<29)
#define ADRM_BOOT_SHFT		29
#define ADRM_SECMSB_MASK	(0x1f<<24)	/* Sec port msbs */
#define ADRM_SECMSB_SHFT	24
#define ADRM_PRIMSB_MASK	(0x1f<<16)	/* Pri port msbs */
#define ADRM_PRIMSB_SHFT	16
#define ADRM_INTACK_MASK	(0x3f<<10)	/* interrupt acks 1=ack */
#define ADRM_INTACK_SHFT	10
#define ADRM_EXCMAP_MASK	(0x7f<<0)	/* Exception adr 80m0.0080 */
#define ADRM_EXCMAP_SHFT	0


#define EDMA_BASE	0xb8000000
#define M_EDMA_TxCompi		(EDMA_BASE+0x00)
				/* read Transmit Completion Queue */
#define M_EDMA_TxConNum		(EDMA_BASE+0x04)
				/* Connection Number for the TxCell command. */
#define M_EDMA_TxCell		(EDMA_BASE+0x08)
				/* Issue a TxCell command. */
#define M_EDMA_TxConAct		(EDMA_BASE+0x10)
		/* Current active ConNum processed by TxCell processor. */
#define M_EDMA_RxCompl		(EDMA_BASE+0x40)
				/* Read Receive Completion Queue. */
#define M_EDMA_RxConNum		(EDMA_BASE+0x44)
				/* Connection Number for the RxCell command. */
#define M_EDMA_RxCell		(EDMA_BASE+0x48)
				/* Issue a RxCell command. */
#define M_EDMA_RxConAct		(EDMA_BASE+0x50)
		/* Current active ConNum processed by RxCell processor. */
#define M_EDMA_RxBuffOffs	(EDMA_BASE+0x58)
				/* Offset for the receive Buffers payload */
#define M_EDMA_Buff		(EDMA_BASE+0x80)
				/* Issue a Buff command. */
#define M_EDMA_ConReAct		(EDMA_BASE+0x88)
		/* Read Buff processor Connection Reactivation message. */
#define M_EDMA_BuffConAct	(EDMA_BASE+0x90)
		/* Current active ConNum processed by Buff processor. */
#define M_EDMA_LBuff		(EDMA_BASE+0x94)
				/* head of Large Free Buffer lists */
#define M_EDMA_SBuff		(EDMA_BASE+0x96)
				/* head of Small Free Buffer lists */
#define M_EDMA_TxBuffOffs	(EDMA_BASE+0x98)
				/* Offset for the transmit Buffers payload */
#define M_EDMA_MoveSrc		(EDMA_BASE+0xa0)
			/* Program the source address for a move command. */
#define M_EDMA_MoveDst		(EDMA_BASE+0xa4)
		/* Program the destination address for a move command. */
#define M_EDMA_MoveCount	(EDMA_BASE+0xa8)
		/* Program the byte count and issue a move command. */
#define M_EDMA_Ctrl		(EDMA_BASE+0xc0)
				/* EDMA control bits */
#define M_EDMA_Status		(EDMA_BASE+0xc4)
				/* Check the EDMA status. */
#define M_EDMA_LBuffSize	(EDMA_BASE+0xc8)
				/* Size of large buffers in bytes */
#define M_EDMA_SBuffSize	(EDMA_BASE+0xca)
				/* Size of small buffers in bytes */
#define M_EDMA_VCD_Base		(EDMA_BASE+0xcc)
				/* Base address of the VC Descriptor Table */
#define M_EDMA_BFD_LBase	(EDMA_BASE+0xd0)
			/* Local Base address of the Buffer Descriptor Table */
#define M_EDMA_BFD_FBase	(EDMA_BASE+0xd2)
			/* Far Base address of the Buffer Descriptor Table */

#define ACI_BASE	0xb8000100
#define M_ACI_Ctrl		(ACI_BASE+0x00) /* ACI Control field */
#define M_ACI_FreeList		(ACI_BASE+0x02)
				/* Beginning of free cell list */
#define M_ACI_TxTimer		(ACI_BASE+0x04) /* Transmit time-out */
#define M_ACI_TxSize		(ACI_BASE+0x05)
				/* Maximum number of cells in Transmit Fifo */
#define M_ACI_TxLimit		(ACI_BASE+0x06)
			/* Number of cells in TxFifo to generate an interrupt */
#define M_ACI_RxLimit		(ACI_BASE+0x07)
			/* Number of cells in RxFifo to generate an interrupt */
#define M_ACI_RxMask		(ACI_BASE+0x08) /* Receive polling mask */
#define M_ACI_Free		(ACI_BASE+0x12)
				/* Get or return a free cell location */
#define M_ACI_RxRead		(ACI_BASE+0x16)
				/* Get cell from Receive Fifo. */
#define M_ACI_TxWrite		(ACI_BASE+0x20) /* Put cell in Transmit Fifo. */
#define M_ACI_RxCells		(ACI_BASE+0x24)
				/* Number of cells in the Receive Fifo */
#define M_ACI_TxCells		(ACI_BASE+0x26)
				/* Number of cells in the Transmit Fifo */
#define M_ACI_Error		(ACI_BASE+0x28)
				/* Get a cell from the Error Fifo */

#define SCD_BASE	0xb8000200
#define M_SCD_Ctrl		(SCD_BASE+0x00) /* Control register */
#define M_SCD_CalSize		(SCD_BASE+0x06) /* Size of the Calendar Table */
#define M_SCD_Now		(SCD_BASE+0x0a) /* Current cell slot pointer */
#define M_SCD_Serv		(SCD_BASE+0x0c) /* execute service command */
#define M_SCD_Sched		(SCD_BASE+0x10) /* execute schedule command */
#define M_SCD_Tic		(SCD_BASE+0x18) /* execute tic command */

#define TM_BASE	0xb8000280
#define M_TM_TimeStamp		(TM_BASE+0x00) /* Time Stamp Counter */
#define M_TM_Timer1		(TM_BASE+0x04) /* Timer Value */
#define M_TM_TimerInit1		(TM_BASE+0x06) /* Timer Initialization value */
#define M_TM_Timer2		(TM_BASE+0x08) /* Timer Value */
#define M_TM_TimerInit2		(TM_BASE+0x0a) /* Timer Initialization value */
#define M_TM_Timer3		(TM_BASE+0x0c) /* Timer Value */
#define M_TM_TimerInit3		(TM_BASE+0x0e) /* Timer Initialization value */
#define M_TM_Timer4		(TM_BASE+0x10) /* Timer Value */
#define M_TM_TimerInit4		(TM_BASE+0x12) /* Timer Initialization value */
#define M_TM_Timer5		(TM_BASE+0x14) /* Timer Value */
#define M_TM_TimerInit5		(TM_BASE+0x16) /* Timer Initialization value */
#define M_TM_Timer6		(TM_BASE+0x18) /* Timer Value */
#define M_TM_TimerInit6		(TM_BASE+0x1a) /* Timer Initialization value */
#define M_TM_Timer7		(TM_BASE+0x1c) /* Timer Value */
#define M_TM_TimerInit7		(TM_BASE+0x1e) /* Timer Initialization value */
#define M_TM_Enable		(TM_BASE+0x20) /* Time-out enable */
#define M_TM_Clear		(TM_BASE+0x24) /* Time-out clear */
#define M_TM_ClockSel		(TM_BASE+0x28) /* Timer clock selection */

#define PP_BASE	0xb8000400
#define M_PP_Ctrl		(PP_BASE+0x03) /* pp control register */
#define M_APU_txMailbox		(PP_BASE+0x08) /* */
#define M_APU_rxMailbox		(PP_BASE+0x04) /* */

#define SBC_BASE	0xb8000800
#define M_SBC_Ctrl		(SBC_BASE+0x00) /* SBC control register */
#define M_SBC_Refresh		(SBC_BASE+0x08) /* SDRAM refresh */

/* secondary bus control register */
#define M_SBCR			0xb8000800	/* Secondary bus cntrl reg */
#define SB_ENPAGE_MASK		(0x1f<<27)
				/* 31 = SDRAM
				 * 30 = SSRAM
				 * 29 = 32-bit SRAM/EPROM
				 * 28 = 8-bit PHY
				 * 27 = 8-bit SRAM/EPROM
				 */
#define SB_WAIT2_MASK		(0xf<<8)
#define SB_WAIT1_MASK		(0xf<<4)
#define SB_WAIT0_MASK		(0xf<<0)

/* SDRAM control register */
#define M_SDRCR			0xb1800804	/* SDRAM cntrl register */
#define SD_PC			(1<<30)
#define SD_MRS			(1<<29)
#define SD_REF			(1<<28)
#define SD_CL_MASK		(3<<20)
#define SD_RCD_MASK		(3<<16)
#define SD_RC_MASK		(15<<12)
#define SD_RAS_MASK		(7<<8)
#define SD_DAL_MASK		(7<<4)
#define SD_RP3			(1<<1)
#define SD_DPL2			(1<<0)

/* SDRAM Refresh Register */
#define M_SDRRR			0xb8000808	/* SDRAM Refresh register */

#endif /* _LR64364_ */
