/*************************************************************
 * File: include/lr4001.h
 * Purpose: defines for LSI Logic LR4001
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970829	Fixed CPC0EN..CPC3EN
 */

#if defined(LR4101) && !defined(LR4001)
#define LR4001
#endif

#if defined(LR4001) && !defined(_LR4001_)
#define _LR4001_

#define M_CFG4001	0xbfff0000	/* config register */

#define CFG_TLBEN	(1<<31)	/* tlb enable */
#define CFG_WBEN	(1<<30)	/* write buffer enable */
#define CFG_DSNOOP	(1<<29)	/* D-snoop enable */
#define CFG_ISNOOP	(1<<28)	/* I-snoop enable */
#define CFG_FBE		(1<<24)	/* fast bus enable */
#define CFG_CPC3EN	(1<<19) /* connect Cpc3 to int */
#define CFG_CPC2EN	(1<<18) /* connect Cpc2 to int */
#define CFG_CPC1EN	(1<<17) /* connect Cpc1 to int */
#define CFG_CPC0EN	(1<<16) /* connect Cpc0 to int */
#define CFG_DBERR	(1<<13)	/* data bus error */
#define CFG_PGSZMASK 	(7<<10) /* page size */
#define CFG_PGSZSHFT 	 10
#define CFG_PGSZ_16 	(0<<10)
#define CFG_PGSZ_32 	(1<<10)
#define CFG_PGSZ_64 	(2<<10)
#define CFG_PGSZ_128 	(3<<10)
#define CFG_PGSZ_256 	(4<<10)
#define CFG_PGSZ_512 	(5<<10)
#define CFG_PGSZ_1K 	(6<<10)
#define CFG_PGSZ_2K 	(7<<10)
#define CFG_CMODEMASK   (3<<8)	/* cache mode */
#define CFG_CMODESHFT    8
#define CFG_CMODE_NORM  (0<<8)
#define CFG_CMODE_IDATA (1<<8)
#define CFG_CMODE_ITEST (2<<8)
#define CFG_CMODE_DTEST (3<<8)
#define CFG_RDPRI 	(1<<7)	/* read priority */
#define CFG_DSIZEMASK	(3<<5)	/* D-cache refill size */
#define CFG_DSIZESHFT	 5
#define CFG_DSIZE_1	(0<<5)
#define CFG_DSIZE_2	(1<<5)
#define CFG_DSIZE_4	(2<<5)
#define CFG_DSIZE_8	(3<<5)
#define CFG_DCEN 	(1<<4)	/* D-cache enable */
#define CFG_ISIZEMASK 	(3<<2)	/* I-cache refill size */
#define CFG_ISIZESHFT 	 2
#define CFG_ISIZE_1 	(0<<2)
#define CFG_ISIZE_2 	(1<<2)
#define CFG_ISIZE_4 	(2<<2)
#define CFG_ISIZE_8 	(3<<2)
#define CFG_IS1EN	(1<<1)	/* I-cache set 1 enable */
#define CFG_ICEN	(1<<0)	/* I-cache enable */

#define M_TMR4001	0xbfff0100
#define O_TIC0		0
#define O_TCC0		4
#define O_TIC1		8
#define O_TCC1		12
#define O_TMODE		16
#define O_TSTAT		20

#define TMODE_EN0	(1<<0)	/* timer enable */
#define TMODE_PULSE0	(1<<1)	/* select pulse or toggle mode */
#define TMODE_EN1	(1<<8)	/* timer enable */
#define TMODE_PULSE1	(1<<9)	/* select pulse or toggle mode */
#define TMODE_DOG1	(1<<10) /* select gp or dog mode */

#define TSTAT_IEN0	(1<<0)	/* interrupt enable */
#define TSTAT_INT0	(1<<1)	/* interrupt status */

#ifdef LANGUAGE_ASSEMBLY

/* Arithmetic bolt-on instructions */
#define MADD(rs,rt)     .word (0x0000001c|((rs)<<21)|((rt)<<16))
#define MADDU(rs,rt)    .word (0x0000001d|((rs)<<21)|((rt)<<16))
#define MSUB(rs,rt)     .word (0x0000001e|((rs)<<21)|((rt)<<16))
#define MSUBU(rs,rt)    .word (0x0000001f|((rs)<<21)|((rt)<<16))

#endif /* LANGUAGE_ASSEMBLY */

#ifdef LANGUAGE_C
#define CFG4001		(*((volatile Ulong *)M_CFG4001)) /* config register */
#define TIC0_4001	(*((volatile Ulong *)(M_TMR4001+O_TIC0))) /* count */
#define TCC0_4001	(*((volatile Ulong *)(M_TMR4001+O_TCC0))) /* cntrl */
#define TIC1_4001	(*((volatile Ulong *)(M_TMR4001+O_TIC1))) /* count */
#define TCC1_4001	(*((volatile Ulong *)(M_TMR4001+O_TCC1))) /* cntrl */
#define TMODE_4001	(*((volatile Ulong *)(M_TMR4001+O_TMODE))) /* mode */
#define TSTAT_4001	(*((volatile Ulong *)(M_TMR4001+O_TSTAT))) /* status */
#endif

#endif /* _LR4001_ */
