/* lr33300.h
 * 	Definitions for the LR33300 and LR33310 processors 
 */

#if defined(LR33300) && !defined(_LR33300_)
#define _LR33300_
#include "ernicore.h"

#define M_SRAM		0xfffe0100	/* SRAM config reg */
#define M_SPEC0		0xfffe0104
#define M_SPEC1		0xfffe0108
#define	M_SPEC2		0xfffe010c
#define	M_SPEC3		0xfffe0110
#define	M_DRAM		0xfffe0120	/* DRAM config reg */

#ifdef LANGUAGE_C
#define SRAM		(*((volatile unsigned long *)M_SRAM))
#define SPEC0		(*((volatile unsigned long *)M_SPEC0))
#define SPEC1		(*((volatile unsigned long *)M_SPEC1))
#define SPEC2		(*((volatile unsigned long *)M_SPEC2))
#define SPEC3		(*((volatile unsigned long *)M_SPEC3))
#define DRAM		(*((volatile unsigned long *)M_DRAM))
#endif

	/* wait-state config registers */
#define	SPC_INHIBITMASK	(0xf<<24)
#define	SPC_INHIBITSHFT	24
#define	SPC_EXTGNT	(1<<23)
#define	SPC_16WIDE	(1<<22)
#define	SPC_8WIDE	(1<<21)
#define	SPC_PENA	(1<<20)
#define	SPC_CACHED	(1<<19)
#define	SPC_CSDLYMASK	(3<<17)
#define	SPC_CSDLYSHFT	17
#define	SPC_BLKENA	(1<<16)
#define	SPC_BLKWAITMASK	(7<<13)
#define	SPC_BLKWAITSHFT	13
#define	SPC_RECMASK	(63<<7)
#define	SPC_RECSHFT	7
#define	SPC_WAITENA	(1<<6)
#define	SPC_WAITMASK	(63<<0)
#define	SPC_WAITSHFT	0

	/* DCR */ 
#define	DRAM_DLP1	(1<<28)
#define	DRAM_SYNC	(1<<27)
#define	DRAM_SCFG	(1<<26)
#define	DRAM_DMARDY	(1<<25)
#define	DRAM_DMABLKMASK	(7<<22)
#define	DRAM_DMABLKSHFT	22
#define	DRAM_DPTHMASK	(3<<20)
#define	DRAM_DPTHSHFT	20
#define	DRAM_RDYW	(1<<19)
#define	DRAM_PGSZMASK	(7<<16)
#define	DRAM_PGSZSHFT	16
#define	DRAM_PGMW	(1<<15)
#define	DRAM_RFWEMASK	(3<<13)
#define	DRAM_RFWESHFT	13
#define	DRAM_RFEN	(1<<12)
#define	DRAM_RDYEN	(1<<11)
#define	DRAM_BFD	(1<<10)
#define	DRAM_PE		(1<<9)
#define	DRAM_RPCMASK	(3<<7)
#define	DRAM_RPCSHFT	7
#define	DRAM_RCDMASK	(3<<5)
#define	DRAM_RCDSHFT	5
#define	DRAM_CS		(1<<4)
#define	DRAM_CLMASK	(7<<1)
#define	DRAM_CLSHFT	1
#define	DRAM_DCE	(1<<0)

#endif /* _LR33300_ */
