/* lr33000.h - defines for LSI Logic LR33000 */

#if defined(LR33000) && !defined(_LR33000_)
#define _LR33000_
#include "cobrcore.h"


/* Define counter/timer register addresses */
#define M_TIC1	0xfffe0000	/* timer 1 initial count */
#define M_TC1	0xfffe0004	/* timer 1 control	 */
#define M_TIC2	0xfffe0008	/* timer 2 initial count */
#define M_TC2	0xfffe000c	/* timer 2 control	 */
#define M_RTIC	0xfffe0010	/* refresh timer	 */

#ifdef LANGUAGE_C
#define TIC1   (*((volatile unsigned long *)M_TIC1)) /* timer1 count */
#define TC1    (*((volatile unsigned long *)M_TC1))  /* timer1 cntrl */
#define TIC2   (*((volatile unsigned long *)M_TIC2)) /* timer2 count */
#define TC2    (*((volatile unsigned long *)M_TC2))  /* timer2 cntrl */
#define RTIC   (*((volatile unsigned long *)M_RTIC)) /* refrsh timer */
#endif

/* Definitions for counter/timer control register bits */
#define TC_CE	 0x00000004	/* count enable */
#define TC_IE	 0x00000002	/* interrupt enable */
#define TC_INT 	 0x00000001	/* interrupt request */

#endif /* _LR33000_ */
