/*************************************************************
 * File: include/l65066.h
 * Purpose: Include file for L65066 (DCAM-111)
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	990212	Created from L9a0084.h
 */

#if defined(L65066) && !defined(_L65066_H_)
#define _L65066_H_

/*
 * Defines for the L65066 (DCAM-111)
 */
#ifndef LR4102
#define LR4102
#endif
#include <lr4102.h>

/*#define USE_FBUS */	/* enable this when switching to the fbus */

#define M_084_R		0xbe100000
#define M_084_TC0	0xbe200000
#define M_084_TCOUNT0	0xbe200004
#define M_084_RCOUNT0	0xbe200008
#define M_084_TC1	0xbe200010
#define M_084_TCOUNT1	0xbe200014
#define M_084_RCOUNT1	0xbe200018
#define M_084_RTCC	0xbe200020
#define M_084_RTCCOUNT	0xbe200024
#define M_084_RTCLOAD	0xbe200028
#define M_084_SYSCLK	0xbe300000
#define SYSCLK_MCLKENP	(1<<0)
#define SYSCLK_BIUCLK	(1<<10)
#define SYSCLK_TMR0CLK	(1<<12)
#define SYSCLK_TMR1CLK	(1<<13)
#define SYSCLK_SIO0CLK	(1<<14)
#define SYSCLK_SIO1CLK	(1<<15)
#define SYSCLK_SIO2CLK	(1<<16)
#define M_084_ACLKDIV0	0xbe300004
#define M_084_ACLKDIV1	0xbe300008
#define M_084_ACLKDIV2	0xbe30000c
#define ACLKDIV_DIV	(0xff<<0)
#define ACLKDIV_DB4	(1<<8)
#define ACLKDIV_EN	(1<<9)
#define ACLKDIV_CSEL	(3<<10)  /* 13.5MHz,20.25MHz,ext2,ext3 */
#define M_084_BDC	0xbe400000
#define M_084_D0C	0xbe400004
#define M_084_D1C	0xbe400008
#define M_084_D2C	0xbe40000c
#define M_084_D3C	0xbe400010
#define M_084_REFRESH	0xbe40001c

/* 
 * Baud rate calculations
 * 	Assumes ACLKDIV0:CSEL = 0 (13.5MHz)
 *	Assumes SOC0=SIC0:CSEL = 1 (iaclkp0)
 *
 *	Baud	DIV	DB4
 *      -------------------
 *	1200	176	1
 *	2400	 88	1
 *	4800	176	0
 *	9600	 88	0
 *	19200	 44	0
 *	38400	 22	0
 */

/* serial port 0 */
#define M_084_SOD0	0xbe900000 /* TX */
#define M_084_SOC0	0xbe900004 /* TX control */
#define M_084_SID0	0xbe900008 /* RX */
#define M_084_SIC0	0xbe90000c /* RX control */

/* serial port 1 */
#define M_084_SOD1	0xbe900010
#define M_084_SOC1	0xbe900014
#define M_084_SID1	0xbe900018
#define M_084_SIC1	0xbe90001c

/* serial port 2 */
#define M_084_SOD2	0xbe900020
#define M_084_SOC2	0xbe900024
#define M_084_SID2	0xbe900028
#define M_084_SIC2	0xbe90002c

/* bit defs for SOC */
#define SOC_EN	   (1<<0)	/* enable */
#define SOC_SD	   (1<<1)	/* shift direction */
/* uart convention is ls bit 1st ie SD=1 */
#define SOC_SM	   (1<<2)	/* synchronous mode */
#define SOC_DB1	   (1<<3)	/* delay by one */
#define SOC_STP	   (1<<4)	/* stop bits 0=1 1=2 */
#define SOC_FC	   (1<<5)	/* cts control */
#define SOC_LEN	   (1<<6)	/* 0=8bits 1=7bits */
#define SOC_PARITY (3<<7) 	/* none,odd,even,nonee */
#define SOC_CI	   (1<<9)	/* clock invert */
#define SOC_CSEL   (3<<10) 	/* clock select sclkp,iaclkp0,iaclkp1,iaclkp2*/
#define SOC_CSEL_1 (1<<10) 	/* clock select iaclkp0 */
#define SOC_CSELSHFT 10 	/* clock select shift amount */
#define SOC_FA	   (1<<14)	/* frame active */
#define SOC_SFNF   (1<<15) 	/* fifo not full */
#define SOC_PDAT   (0xf<<16) 	/* pin data */
#define SOC_PCFG   (0xf<<20) 	/* pin config */

/* bit defs for SIC */
#define SIC_EN	   (1<<0)	/* enable */
#define SIC_SD	   (1<<1)	/* shift direction */
#define SIC_SM	   (1<<2)	/* syncronous mode */
#define SIC_DB1	   (1<<3)	/* delay by one */
#define SIC_LEN	   (1<<6)	/* 0=8bits 1=7bits */
#define SIC_PARITY (3<<7) 	/* none,odd,even,nonee */
#define SIC_CI	   (1<<9)	/* clock invert */
#define SIC_CSEL   (3<<10) 	/* clock select */
#define SIC_CSEL_1 (1<<10) 	/* clock select iaclkp0 */
#define SIC_CSELSHFT 10 	/* clock select shift amount */
#define SIC_FA	   (1<<14)	/* frame active */
#define SIC_SFNE   (1<<15) 	/* fifo not empty */
#define SIC_PDAT   (0xf<<16) 	/* pin data */
#define SIC_PCFG   (0xf<<20) 	/* pin config */
#define SIC_FE	   (1<<28)	/* framing error */
#define SIC_PE	   (1<<29)	/* parity error */
#define SIC_OVE	   (1<<30)	/* overrun error */
#define SIC_SE	   (1<<31)	/* sum of error */

/* interrupt handler */
#define M_084_ICAUSE	0xbea00000
#define M_084_IMASK	0xbea00004


#endif /*  _L65066_H_ */
