#if 0
--------------------------------------------------------------------------
Copyright 1994 LSI Logic Corporation		LSI LOGIC PROPRIETARY
All Rights Reserved


THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT ANY EXPRESS OR IMPLIED WARRANTY.

LSI LOGIC DISCLAIMS ALL REPRESENTATIONS AND WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL LSI LOGIC BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACT OR OMISSION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
--------------------------------------------------------------------------
#endif
/* hosif.h - defines for Host OS InterFace. For use in hosif.c,
 * which contains the function definitions for the hosif 
 * pseudo-device, and in the 'interceptor' library functions
 * which provide a Unix-alike interface for client programs.
 * (e.g. a function fprintf() can be defined to package up
 * the appropriate series of writes and reads of the hosif 
 * device registers to initiate an fprintf() call to the host
 * OS).
 */

/* $Header: /proj/software/pub/CVSROOT/mips/monitors/pmon/include/hosif.h,v 1.2 2001/07/10 00:02:36 rsewill Exp $ */


/* Defines for the register names.
 * NOTE: program references must be non-cacheable, which for
 * the standard Cobra translation scheme can be guaranteed by using
 * addrs in Kseg1 - above 0xa0000000.
 * 	The physical address can be anywhere in principle, but for now
 * is defined at 0x01000000 in hosif.c 
 */
#define CMD_OFFS	0x0
#define RETV_OFFS	0x4

#define ARG1_OFFS	0x8
#define ARG2_OFFS	0xc
#define ARG3_OFFS	0x10
#define ARG4_OFFS	0x14
#define ARG5_OFFS	0x18
#define ARG6_OFFS	0x1c
#define ARG7_OFFS	0x20
#define ARG8_OFFS	0x24

/* Defines for virtual adrs - used in interceptor functions */
#define BASE_VADR	0xa1000000

#define CMD_VADR    (BASE_VADR + CMD_OFFS)
#define RETV_VADR   (BASE_VADR + RETV_OFFS)

#define ARG1_VADR   (BASE_VADR + ARG1_OFFS)
#define ARG2_VADR   (BASE_VADR + ARG2_OFFS)
#define ARG3_VADR   (BASE_VADR + ARG3_OFFS)
#define ARG4_VADR   (BASE_VADR + ARG4_OFFS)
#define ARG5_VADR   (BASE_VADR + ARG5_OFFS)
#define ARG6_VADR   (BASE_VADR + ARG6_OFFS)
#define ARG7_VADR   (BASE_VADR + ARG7_OFFS)
#define ARG8_VADR   (BASE_VADR + ARG8_OFFS)

/* Defines for physical adrs - used in hosif */
#define BASE_PADR	0x01000000

#define CMD_PADR    (BASE_PADR + CMD_OFFS)
#define RETV_PADR   (BASE_PADR + RETV_OFFS)

#define ARG1_PADR   (BASE_PADR + ARG1_OFFS)
#define ARG2_PADR   (BASE_PADR + ARG2_OFFS)
#define ARG3_PADR   (BASE_PADR + ARG3_OFFS)
#define ARG4_PADR   (BASE_PADR + ARG4_OFFS)

/* Defines for pseudo-device commands */
#define OPEN_CMD   0x1
#define CLOSE_CMD  0x2
#define READ_CMD  0x3
#define WRITE_CMD  0x4
#define LSEEK_CMD  0x5
#define CREAT_CMD  0x6

