/* eload.h - elf record definitions
 *
 */

/* ELF identification offsets */

#define EI_MAG0			0
#define EI_MAG1			1
#define EI_MAG2			2
#define EI_MAG3			3
#define EI_CLASS		4
#define EI_DATA			5
#define EI_VERSION		6
#define EI_PAD			7		/* start of pad */
#define EI_NIDENT		16		/* size of e_ident[] record */

/* various elf record values */

#define ELFMAG0			0x7f
#define ELFMAG1			'E'
#define ELFMAG2			'L'
#define ELFMAG3			'F'

/* EI_CLASS values */
#define ELFCLASS32		1		/* 32 bit processor class */

/* EI_DATA values */
#define	ELFDATA2MSB		2		/* big endien */

/* EI_VERSION and e_version values */
#define EV_CURRENT		1		/* elf record version */

/* e_type values */
#define ET_EXEC			2		/* executable file */

/* e_machine values */
#define EM_MIPS			8		/* MIPS RS3000 */

/* p_type values */
#define PT_NULL			0				/* array element unused */
#define	PT_LOAD			1				/* loadable segment */
#define PT_DYNAMIC		2				/* dynamic linking information */
#define PT_INTERP		3				/* path name for an interpretter */
#define PT_NOTE			4				/* auxiliary information */
#define PT_SHLIB		5				/* reserved, unspecified semantics */
#define PT_PHDR			6				/* program header table location */
#define PT_LOPROC		0x70000000		/* processor specific semantics low */
#define PT_HIPROC		0x7fffffff		/* processor specific semantics high */

/* sh_type values */
#define SHT_NULL		0		/* inactive section */
#define SHT_PROGBITS	1		/* information defined by the program */
#define SHT_SYMTAB		2		/* symbol table */
#define SHT_STRTAB		3		/* string table */
#define SHT_RELA		4		/* relocations entries, explicit addends */
#define SHT_HASH		5		/* symbol hash table */
#define SHT_DYNAMIC		6		/* dynamic linking information */
#define SHT_NOTE		7		/* info that marks files in some way */
#define SHT_NOBITS		8		/* occupies no space in file */
#define SHT_REL			9		/* relocation entries, no explicit addends */
#define SHT_SHLIB		10		/* reserved, unspecified */
#define SHT_DYNSYM		11		/* symbol table */
#define SHT_LOPROC		0x70000000		/* reserved processor specific low */
#define SHT_HIPROC		0x7fffffff		/* reserved processor specific high */
#define SHT_LOUSER		0x80000000		/* reserved app specific lo */
#define SHT_HIUSER		0xffffffff		/* reserved app specific hi */

/* sh_link values */
#define SHN_UNDEF		0		/* undefined, or missing section reference */
#define SHN_LORESERVE	0xff00	/* lower bound of range of reserved indexes */
#define SHN_LOPROC		0xff00	/* processor specific low */
#define SHN_HIPROC		0xff1f	/* processor specific high */
#define SHN_ABS			0xfff1	/* absolute value */
#define SHN_COMMON		0xfff2	/* common symbol */
#define SHN_HIRESEREVE	0xffff	/* upper bound of range of reserved indexes */

/* sh_flags values */
#define SHF_WRITE		0x1				/* write enable section */
#define SHF_ALLOC		0x2				/* section occupies execution memory */
#define SHF_EXECINSTR	0x4				/* section contains instructions */
#define SHF_MASKPROC	0xf0000000		/* processor specific bits */

/* defines for extracting type and binding attributes from st_info values */
#define ELF32_ST_BIND(i)		((i)>>4)
#define ELF32_ST_TYPE(i)		((i)&0xf)
#define ELF32_ST_INFO(b,t)		(((b)<<4)+((t)&0xf))

/* ELF32_ST_BIND values */
#define STB_LOCAL		0
#define STB_GLOBAL		1
#define STB_WEAK		2
#define STB_LOPROC		13
#define STB_HIPROC		15

/* ELF32_ST_TYPE values */
#define STT_NOTYPE		0
#define STT_OBJECT		1
#define STT_FUNC		2
#define STT_SECTION		3
#define STT_FILE		4
#define STT_LOPROC		13
#define STT_HIPROC		15

/* return codes from eload */

#define ELFNORMAL_EOF			0		/* no more data */
#define ELFNORMAL_HEADER		1		/* elf header record */
#define ELFNORMAL_DATA			2		/* elf data record */

#define ELFERR_NOTELF			-1		/* not elf record */
#define ELFERR_BADENDIEN		-2		/* bad endien type */
#define ELFERR_BADCLASS			-3		/* wrong process class */
#define ELFERR_BADHVERSION		-4		/* bad elf record header version */
#define ELFERR_BADVERSION		-5		/* bad elf record version */
#define ELFERR_UNSUPPORTEDOBJ	-6		/* unsupported object type */
#define ELFERR_NOTMIPS			-7		/* not MIPS code */

typedef unsigned long	Elf32_Addr;
typedef unsigned long	Elf32_Word;
typedef unsigned long	Elf32_Off;
typedef long			Elf32_Sword;
typedef unsigned short	Elf32_Half;

typedef struct {
  unsigned char			e_ident[EI_NIDENT];
  Elf32_Half			e_type;
  Elf32_Half			e_machine;
  Elf32_Word			e_version;
  Elf32_Addr			e_entry;
  Elf32_Off				e_phoff;
  Elf32_Off				e_shoff;
  Elf32_Word			e_flags;
  Elf32_Half			e_ehsize;
  Elf32_Half			e_phentsize;
  Elf32_Half			e_phnum;
  Elf32_Half			e_shentsize;
  Elf32_Half			e_shnum;
  Elf32_Half			e_shstrndx;
} Elf32_Ehdr;

typedef struct {
  Elf32_Word			p_type;
  Elf32_Off				p_offset;
  Elf32_Addr			p_vaddr;
  Elf32_Addr			p_paddr;
  Elf32_Word			p_filesz;
  Elf32_Word			p_memsz;
  Elf32_Word			p_flags;
  Elf32_Word			p_align;
} Elf32_Phdr;

typedef struct {
  Elf32_Word			sh_name;
  Elf32_Word			sh_type;
  Elf32_Word			sh_flags;
  Elf32_Addr			sh_addr;
  Elf32_Off				sh_offset;
  Elf32_Word			sh_size;
  Elf32_Word			sh_link;
  Elf32_Word			sh_info;
  Elf32_Word			sh_addralign;
  Elf32_Word			sh_entsize;
} Elf32_Shdr;

typedef struct {
  Elf32_Word			st_name;
  Elf32_Addr			st_value;
  Elf32_Word			st_size;
  unsigned char			st_info;
  unsigned char			st_other;
  Elf32_Half			st_shndx;
} Elf32_Sym;
