/*************************************************************
 * File: include/dbxcore.h
 * Purpose: provides defines for stuff in the DBX module.
 *      This has nothing whatever to do with MIPS's dbx, their source-
 *      level debugger.
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970224	Start of revision history
 */

#ifndef _DBX_CORE_
#define _DBX_CORE_
#define DBX_CORE

/* DCS register */
#define DCS_TR		(1<<31)		/* trap enable */
#define DCS_UD		(1<<30)		/* detect debug events in user mode */
#define DCS_KD		(1<<29)		/* detect debug events in kernel mode */
#define DCS_TE		(1<<28)		/* detect trace events */
#define DCS_DW		(1<<27)		/* detect data write at BDA */
#define DCS_DR		(1<<26)		/* detect data read at BDA */
#define DCS_DAE		(1<<25)		/* enable data address breakpoints */
#define DCS_PCE		(1<<24)		/* enable PC address breakpoints */
#define DCS_DE		(1<<23)		/* debug enable */
#define DCS_IBD		(1<<22)		/* internal break disable (4002) */
#define DCS_EBE		(1<<21)		/* external break enable (4002) */
#define DCS_T		(1<<5)		/* trace event detected */
#define DCS_W		(1<<4)		/* write matching BDA detected */
#define DCS_R		(1<<3)		/* read matching BDA detected */
#define DCS_DA		(1<<2)		/* data address matching BDA detected */
#define DCS_PC		(1<<1)		/* PC address detected */
#define DCS_DB		(1<<0)		/* debug condition detected */


#ifdef LANGUAGE_C
/* these registers have the same number whether they are accessed via
 * mfdbx/mtdbx instructions are mtc0/mfc0 instructions.
 */
#define DBX_DCS		7
#define DBX_BPC		18
#define DBX_BDA		19
#define DBX_BPCM	20
#define DBX_BDAM	21
/* mfdbx() and mtdbx() */
#else
#define DBX_DCS		$7
#define DBX_BPC		$18
#define DBX_BDA		$19
#define DBX_BPCM	$20
#define DBX_BDAM	$21

#ifdef ALGOR
#define mfd(d,s)	.set nowarn;\
			.word (0x7C000000|(d<<16)|(s<<11));\
			.set warn; 42:
#define mtd(s,d)	.set nowarn;\
			.word (0x78000000|(d<<11)|(s<<21));\
			.set warn; 42:
#else
#define mfd(d,s) 	.word (0x7C000000|(d<<16)|(s<<11))
#define mtd(s,d)	.word (0x78000000|(d<<11)|(s<<21))
#endif
#endif

#endif /* _DBX_CORE_ */
