/*************************************************************
 * File: irq.c
 * 	This file contains an example of using the new IRQInstall()
 *	library function. It permits installation of an interrupt
 *	handler without requiring even a single line of assembly language. 
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	961208	Created
 *	990115	Updated to support the bdmr4102
 */

#include <utypes.h>

int seconds;
int ticks;

#if defined(BDMR4101) || defined(BDMR4011) || defined(BDMR5000)
#ifdef MIPSEB
#define M_S2681_BASE 0xbe000003
#else
#define M_S2681_BASE 0xbe000000
#endif
#define SIO_CTU    *((volatile unsigned char *)(M_S2681_BASE+0x18))
#define SIO_CTL    *((volatile unsigned char *)(M_S2681_BASE+0x1c))
#define SIO_IMR    *((volatile unsigned char *)(M_S2681_BASE+0x14))
#define SIO_STPCTR *((volatile unsigned char *)(M_S2681_BASE+0x3c))
#define IMR_CTRRDY (1<<3)

/* This value varies from board to board. Enable one only  */
/*#define SIO_IRQNum	4	/* Pocket Rocket */
/*#define SIO_IRQNum	5	/* RacerXc */
/*#define SIO_IRQNum	4	/* ATMizer-I R/T */
/*#define SIO_IRQNum	6	/* Turbo Rocket */
/*#define SIO_IRQNum	2	/* uMeteor */
/*#define SIO_IRQNum	2	/* Nitro */

/* BDMR4101 and BDMR4011 use the same value */
#define IRQNum	2

#define TIMER_VALUE 1152	/* 10ms */
#endif

#ifdef BDMR4102
#include <mips.h>

#define inw(a)		(*((volatile Ulong *)(a)))
#define outw(a,v)	(*((volatile Ulong *)(a))=(v))

/* 4102 cpu 32-bit timer */
#define TMRI    (M_TMR4001+O_TIC1)  /* initial value */
#define TMRC    (M_TMR4001+O_TCC1)  /* current value */
#define TMODE   (M_TMR4001+O_TMODE) /* control */
#define TSTAT   (M_TMR4001+O_TSTAT) /* status */

#define IRQNum	5
#endif

/*************************************************************
*/
main()
{
long t1,t2,i;
int isr();

IRQInstall(IRQNum,isr);

#if defined(BDMR4101) || defined(BDMR4011) || defined(BDMR5000)
/* init the timer */
SIO_CTU = (TIMER_VALUE>>8);
SIO_CTL = (TIMER_VALUE&0xff);
SIO_IMR = IMR_CTRRDY;
#endif

#ifdef BDMR4102
{
Ulong cf,tmode,tstat;

tmode = inw(TMODE)&~TMODE_MASK1;
tstat = inw(TSTAT)&~TSTAT_MASK1;
cf = 1000000*100; /* 100 MHZ clock */
outw(TMRI,cf/100); /* 10ms based on CPU clock frequency */
outw(TMODE,tmode|TMODE_I1);  /* invert */
outw(M_SCR2,inw(M_SCR2)|SCR2_TMRIE1);
outw(TSTAT,tstat|TSTAT_IE1); /* int enable */
outw(TMODE,tmode|TMODE_I1|TMODE_E1);  /* invert+enable */
}
#endif

t1 = seconds;
for (i=0;;i++) {
	t2 = seconds;
	if (t2-t1 >= 1) {
		t1 = t2;
		printf("\r%5d ",t2);
		}
	if ((i%100000)==0) printf(".");
	}
}

/*************************************************************
*/
isr()
{

#if defined(BDMR4101) || defined(BDMR4011) || defined(BDMR5000)
{
char dummy;
dummy = SIO_STPCTR; /* ack the timer */
}
#endif

#ifdef BDMR4102
outw(TSTAT,inw(TSTAT)&~TSTAT_IN1); /* ack timer int */
#endif

ticks++;
if (ticks > 100) {
	ticks = 0;
	seconds++;
	}
return(1);
}

