#include "mips.h"
#include "stdio.h"
#include "termio.h"

/*
 * This example displays the elapsed time in large digits.
 */

long time();

int x_posn[] = {4,12,20,28,36,44,52,60};
int y_posn = 10;

/* encode chars using a 5x7 matrix */
unsigned char bitmap[7][11] = {
/*	  0    1    2    3    4    5    6    7    8    9     :   */
	{0x1f,0x04,0x1f,0x1f,0x10,0x1f,0x1f,0x1f,0x1f,0x1f,0x00},
	{0x11,0x04,0x01,0x01,0x14,0x10,0x10,0x01,0x11,0x11,0x00},
	{0x11,0x04,0x01,0x01,0x14,0x10,0x10,0x01,0x11,0x11,0x04},
	{0x11,0x04,0x1f,0x1f,0x1f,0x1f,0x1f,0x02,0x1f,0x1f,0x00},
	{0x11,0x04,0x10,0x01,0x04,0x01,0x11,0x04,0x11,0x01,0x04},
	{0x11,0x04,0x10,0x01,0x04,0x01,0x11,0x08,0x11,0x01,0x00},
	{0x1f,0x04,0x1f,0x1f,0x04,0x1f,0x1f,0x10,0x1f,0x1f,0x00}
	};

main(argc,argv)
int argc;
char *argv[];
{
long secs,prev,i,mins,v;
char buf[6],p_buf[6];

if (argc == 2) {
	if (!atob(&v,argv[1],0)) {
		printf("bad initial time value\n");
		exit(1);
		}
	printf("setting initial value to %d\n",v);
	stime(&v);
	}
if (ttctl(STDOUT,TT_CLR)== -1) {
	printf("ttytype not set\n");
	exit(1);
	}
for (i=0;i<6;i++) p_buf[i] = 0;
for (prev=0;;) {
	secs = time(0);
	if (secs != prev) {
		mins = secs/60;
		sprintf(buf,"%02d:%02d:%02d",mins/60,mins%60,secs%60);
		for (i=0;i<strlen(buf);i++) {
			if (buf[i] != p_buf[i]) {
				printchar(buf[i],x_posn[i],y_posn);
				}
			p_buf[i] = buf[i];
			}
		prev = secs; 
		}
	}
}

printchar(c,x,y)
char c;
int x,y;
{
int i,j,n,m,byte;

for (i=0;i<7;i++) {
	ttctl(STDOUT,TT_CM,x,y+i);
	if (c == ':') n = 10;
	else n = c - '0';
	byte = bitmap[i][n];
	for (m=4;m>=0;m--) {
		if (getbit(byte,m)) printf("x");
		else printf(" ");
		}
	}
}

getbit(b,n)
int b,n;
{
int mask;

mask = 1<<n;

if ((b&mask) == 0) return(0);
return(1);
}

