######################################################################
#     This file contains information about your configuration.       #
######################################################################

MIPSTOOLSPREFIX=mips-
CC = $(MIPSTOOLSPREFIX)gcc
LD = $(MIPSTOOLSPREFIX)ld
OBJCOPY = $(MIPSTOOLSPREFIX)objcopy

GENFLAGS := -mno-gpopt -fno-pic -mno-abicalls -ggdb -DPMCC -DCYGNUS 
GENFLAGS += -fno-builtin -nostdinc -msoft-float -I$(PMON)/include

CFLAGS = $(GENFLAGS) $(TFLAG) $(OPTLEV)
ASFLAGS = $(GENFLAGS) $(TFLAG) $(OPTLEV)

CFLAGS += -funsigned-char -DLANGUAGE_C $(EXTRA_CFLAGS)
ASFLAGS += -DLANGUAGE_ASSEMBLY -x assembler-with-cpp -traditional

# turn on special FPGA code if building for FPGA
ifdef FPGA_SPECIAL
CFLAGS += -DBUILD_FOR_FPGA
endif

CFLAGS+=-D_FLASH8MB

.SUFFIXES: .o .s
LIB_ONLY = LIBd
CLEAN_DIRS =  LIBd MONd PMONd EXAMPLESd
PMON_TARG =  BGd
MON_TARG =  BGd
LIB_TARG =  BGd BOd
ALL_TARG = lib-only MONd PMONd EXAMPLESd
FPEM_DIR = lib
EDIR = bg
RMF = rm -f
TOOLOBJS = $(CFILES:.c=)
RMFOBJS = rm -f $(OBJS)
# tools type CYGUNIXELF
TOOLSET = CYGUNIXELF
AR = $(MIPSTOOLSPREFIX)ar cr
PMCC = cygelf.c
SPCLTOOLS = edown
OPTLEV = -Os -fno-schedule-insns2
NMOD = x
# fp emulation type NONE

