/*************************************************************
 * File: d4102.c
 * Purpose: SerialICE driver for LSI 4102
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970527	Created from d4003.c
 *	970709	Added code to fix rom bpt w irefill=8
 *	970828	Added ifdef for USE_ICEPORT
 *	970829	Fixed CPC0EN..CPC3EN
 *	970829	Added HI and LO registers
 *	980102	Added USE_DBX and USE_ILOCK switches
 *	980127	Added test for ICEN in ilockReq
 *	980223	Replaced write_target ops in flush_target w send_instr.
 *	980312	Switched to unified scheme for dll and imon.
 *	980615	Created from d4101.c
 *	990203	Fixed LO and HI (33 & 32) was reversed.
 */

#ifndef LR4102
#define LR4102
#endif
#include "iceif.h"

#define USE_ICEPORT		/* use the on-chip serialICE port */

#ifdef PMCC /* disable this block for DLL builds */
char _drivername[] = "Driver for LR4102";

/*************************************************************
*	This file contains all the register definitions used
*	by the 'r' (display regs) command. There are two types
*	of definitions: RegList that defines all the registers, 
*	and RegSpec's that define the bit fields within a register.
*/

static RegSpec scr1[] = {
        {1,30,"WBEN",2,0,0},
        {1,29,"DSNOOP",2,0,0},
        {1,28,"ISNOOP",2,0,0},
        {1,24,"FBE",2,0,0},
        {1,19,"CPC3EN",2,0,0},
        {1,18,"CPC2EN",2,0,0},
        {1,17,"CPC1EN",2,0,0},
        {1,16,"CPC0EN",2,0,0},
        {1,13,"DBERR",2,0,0},
        {3,10,"PGSZ",10,0,0},
        {2,8,"CMODE",10,0,0},
        {1,7,"RDPRI",2,0,0},
        {2,5,"DSIZE",10,0,0},
        {1,4,"DCEN",2,0,0},
        {2,2,"ISIZE",10,0,0},
        {1,1,"IS1",2,0,0},
        {1,0,"ICEN",2,0,0},
        {0}}; 

static RegSpec Stat[] = {
	{4,28,"CU",2,0,0},
	{1,22,"BEV",2,0,0},
	{1,21,"TS",2,0,1},
	{1,20,"PE",2,0,1},
	{1,19,"CM",2,0,0},
	{1,18,"PZ",2,0,0},
	{1,17,"SWC",2,0,0},
	{1,16,"ISC",2,0,0},
	{8,8,"IM&SW",2,0,0},
	{1,5,"KUo",2,0,0},
	{1,4,"IEo",2,0,0},
	{1,3,"KUp",2,0,0},
	{1,2,"IEp",2,0,0},
	{1,1,"KUc",2,0,0},
	{1,0,"IEc",2,0,0},
	{0}};

static RegSpec TmrMode[] = {
        {1,10,"DOG1",2,0,0},
        {1,9,"PULSE1",2,0,0},
        {1,8,"EN1",2,0,0},
        {1,1,"PULSE0",2,0,0},
        {1,0,"EN0",2,0,0},
        {0}};

static RegSpec TmrStat[] = {
        {1,1,"INT0",2,0,0},
        {1,0,"IEN0",2,0,0},
        {0}};

static RegSpec Caus[] = {
	{1,31,"BD",2,0,1},
	{2,28,"CE",10,0,1},
	{6,10,"IP",2,0,1},
	{2,8,"SW",2,0,0},
	{4,2,"EXCODE",0,excodes,1},
	{0}};

static RegSpec PRid[] = {
	{8,8,"IMP",10,0,1},
	{8,0,"Rev",10,0,1},
	{0}};

static RegRec reglist[] = {
	{mXpc,0,"PC","pc",14,(F_MIPS|F_CPU)},
	{mXgpr,0,"LO","LO",33,(F_MIPS|F_CPU)},
	{mXgpr,0,"HI","HI",32,(F_MIPS|F_CPU)},
	{mXc0,Stat,"C0_SR","SR",12,(F_MIPS|F_CP0)},
	{mXc0,Caus,"C0_CAUSE","CAUSE",13,(F_MIPS|F_CP0)},
	{mXc0,PRid,"C0_PRID","PRID",15,(F_MIPS|F_CP0)},
	{mXc0,0,"C0_EPC","EPC",14,(F_MIPS|F_CP0)},
	{mXc0,0,"C0_BADVA","BADVA",8,(F_MIPS|F_CP0)},
        {mXmem,scr1,"M_SCR1","SCR1",M_SCR1,0},
        {mXmem,0,"M_TIC0","TIC0",O_TIC0,0},
        {mXmem,0,"M_TCC0","TCC0",O_TCC0,0},
        {mXmem,0,"M_TIC1","TIC1",O_TIC1,0},
        {mXmem,0,"M_TCC1","TCC1",O_TCC1,0},
        {mXmem,TmrMode,"M_TMODE","TMODE",M_TMR4001+O_TMODE,0},
        {mXmem,TmrStat,"M_TSTAT","TSTAT",M_TMR4001+O_TSTAT,0},
#if 0
        {mXmem,0,"M_FACFG0","FACFG0",M_FACFG0,0},
        {mXmem,0,"M_FACFG1","FACFG1",M_FACFG1,0},
        {mXmem,0,"M_FACFG2","FACFG2",M_FACFG2,0},
        {mXmem,0,"M_FACFG3","FACFG3",M_FACFG3,0},
        {mXmem,0,"M_FACFG4","FACFG4",M_FACFG4,0},
        {mXmem,0,"M_FACFG5","FACFG5",M_FACFG5,0},
        {mXmem,0,"M_FBUSTA","FBUSTA",M_FBUSTA,0},
        {mXmem,0,"M_FACMP0","FACMP0",M_FACMP0,0},
        {mXmem,0,"M_FACMP1","FACMP1",M_FACMP1,0},
        {mXmem,0,"M_FACMP2","FACMP2",M_FACMP2,0},
        {mXmem,0,"M_FACMP3","FACMP3",M_FACMP3,0},
        {mXmem,0,"M_FACMP4","FACMP4",M_FACMP4,0},
        {mXmem,0,"M_FACMP5","FACMP5",M_FACMP5,0},
#endif
	{0}};

int cache_cmd_400x();
extern Optdesc cache_opts_400x[];

CmdRec cmdlist[] = {
	{"cache",cache_opts_400x,cache_cmd_400x},
	{0}};

/*************************************************************
*  dvrInit()
*/
dvrInit()
{
int i;
int accesstst();

ice_baud = B38400; /* ignored for ICEPORT */
#ifdef USE_ICEPORT
ice_device = "/dev/tty2";
#else
ice_device = "/dev/tty1";
#endif
for (i=0;reglist[i].func;i++) addRegRec(&reglist[i]);
addicecmds();
for (i=0;cmdlist[i].name;i++) addCmdRec(&cmdlist[i]);
need_initial_flush = 1;

#if 0 
/* Example Ocm region that uses an access routine. To use this you
 * must link your access routine (eg. accesstst.o) with your driver. 
 * This method is only used for IMON. For the DLL you need to add a
 * command to your serialice1.cfg file.
 */
addOcmRec(0xa0040000,0x1000,accesstst,accesstst(3));
#endif

init_4102();
}
#endif /* this block is disabled for DLL builds */

void init_4102(void)
{
printDiag(1,"init_4102\n");
flush_target_ptr = flush_target_400x;
brkInstall_ptr = brkInstall_400x;
ilockReq_ptr = ilockReq_400x;
brkRemove_ptr = brkRemove_400x;
setFlushneeded_ptr = setFlushneeded_400x;

_cputype = 4102;
has_ilock = 1;
has_nhwdb = 0;
has_nhwib = 0;
icache_size = 8*1024;
dcache_size = 8*1024;
cache_line_size = 16;
}


