/*************************************************************
 * File: bsps/d4011.c
 * Purpose: SerialICE driver for LSI 4011
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970128	Created
 *	971203	Changed default to the iceport (tty2)
 *	980312	Switched to unified scheme for dll and imon.
 *	990203	Fixed offset for HI register (was 33).
 */

#ifndef LR4010
#define LR4010
#endif
#include "iceif.h"

#ifdef PMCC
char _drivername[] = "Driver for LR4011";

/*************************************************************
*	This file contains all the register definitions used
*	by the 'r' (display regs) command. There are two types
*	of definitions: RegList that defines all the registers, 
*	and RegSpec's that define the bit fields within a register.
*/

static RegSpec CCCreg4010[] = {
	{1,27,"SDB",2,0,0},
	{1,26,"ISR1",2,0,0},
	{1,25,"EVI",2,0,0},
	{1,24,"CMP",2,0,0},
	{1,23,"IIE",2,0,0},
	{1,22,"DIE",2,0,0},
	{1,21,"MUL",2,0,0},
	{1,20,"MAD",2,0,0},
	{1,19,"TMR",2,0,0},
	{1,18,"BGE",2,0,0},
	{1,17,"IE0",2,0,0},
	{1,16,"IE1",2,0,0},
	{2,14,"IS",10,0,0},
	{1,13,"DE0",2,0,0},
	{1,12,"DE1",2,0,0},
	{2,10,"DS",10,0,0},
	{1,9,"IPWE",2,0,0},
	{2,7,"IPWS",10,0,0},
	{1,6,"TE",2,0,0},
	{1,5,"WB",2,0,0},
	{1,4,"SR0",2,0,0},
	{1,3,"SR1",2,0,0},
	{1,2,"ISC",2,0,0},
	{1,1,"TAG",2,0,0},
	{1,0,"INV",2,0,0},
	{0}};

static RegSpec DCSreg4010[] = {
	{1,31,"TR",2,0,0},
	{1,30,"UD",2,0,0},
	{1,29,"KD",2,0,0},
	{1,28,"TE",2,0,0},
	{1,27,"DW",2,0,0},
	{1,26,"DR",2,0,0},
	{1,25,"DAE",2,0,0},
	{1,24,"PCE",2,0,0},
	{1,23,"DE",2,0,0},
	{1,5,"T",2,0,0},
	{1,4,"W",2,0,0},
	{1,3,"R",2,0,0},
	{1,2,"DA",2,0,0},
	{1,1,"PC",2,0,0},
	{1,0,"DB",2,0,0},
	{0}};

static RegSpec SCerreg4010[] = {
	{1,1,"BEDE",2,0,0},
	{1,0,"BERR",2,0,0},
	{0}};

static RegSpec EVintreg4010[] = {
	{1,1,"HEVI",2,0,0},
	{1,0,"SEVI",2,0,0},
	{0}};

#ifdef FLOATINGPT
static char *rmvalues[] = {"RN","RZ","RP","RM",0};

static RegSpec cp1_csr[] = {
	{1,23,"C",2,0,0},
	{1,17,"EE",2,0,0},
	{1,16,"EV",2,0,0},
	{1,15,"EZ",2,0,0},
	{1,14,"EO",2,0,0},
	{1,13,"EU",2,0,0},
	{1,12,"EI",2,0,0},
	{1,11,"TV",2,0,0},
	{1,10,"TZ",2,0,0},
	{1, 9,"TO",2,0,0},
	{1, 8,"TU",2,0,0},
	{1, 7,"TI",2,0,0},
	{1, 6,"SV",2,0,0},
	{1, 5,"SZ",2,0,0},
	{1, 4,"SO",2,0,0},
	{1, 3,"SU",2,0,0},
	{1, 2,"SI",2,0,0},
	{1, 0,"RM",0,rmvalues,0},
	{0}};
#endif

static RegSpec Stat[] = {
	{4,28,"CU",2,0,0},
	{1,22,"BEV",2,0,0},
	{1,21,"TS",2,0,1},
	{1,20,"PE",2,0,1},
	{1,19,"CM",2,0,0},
	{1,18,"PZ",2,0,0},
	{1,17,"SWC",2,0,0},
	{1,16,"ISC",2,0,0},
	{8,8,"IM&SW",2,0,0},
	{1,5,"KUo",2,0,0},
	{1,4,"IEo",2,0,0},
	{1,3,"KUp",2,0,0},
	{1,2,"IEp",2,0,0},
	{1,1,"KUc",2,0,0},
	{1,0,"IEc",2,0,0},
	{0}};

static RegSpec Caus[] = {
	{1,31,"BD",2,0,1},
	{2,28,"CE",10,0,1},
	{6,10,"IP",2,0,1},
	{2,8,"SW",2,0,0},
	{4,2,"EXCODE",0,excodes,1},
	{0}};

static RegSpec PRid[] = {
	{8,8,"IMP",10,0,1},
	{8,0,"Rev",10,0,1},
	{0}};

static RegRec reglist[] = {
	{mXpc,0,"PC","pc",14,(F_MIPS|F_CPU)},
	{mXgpr,0,"HI","HI",32,(F_MIPS|F_CPU)},
	{mXgpr,0,"LO","LO",33,(F_MIPS|F_CPU)},
	{mXc0,Stat,"C0_SR","SR",12,(F_MIPS|F_CP0)},
	{mXc0,Caus,"C0_CAUSE","CAUSE",13,(F_MIPS|F_CP0)},
	{mXc0,PRid,"C0_PRID","PRID",15,(F_MIPS|F_CP0)},
	{mXc0,0,"C0_EPC","EPC",14,(F_MIPS|F_CP0)},
	{mXc0,0,"C0_BADVA","BADVA",8,(F_MIPS|F_CP0)},
	{mXc0,CCCreg4010,"C0_CCC","CCC",16,0},
	{mXc0,DCSreg4010,"C0_DCS","DCS",7,0},
	{mXmem,SCerreg4010,"M_SCBUS","SCBUS",M_SCBUS_ST,0},
	{mXmem,EVintreg4010,"M_EXVI","EXVI",M_EXVI,0},
	{mXc0,0,"C0_PAGEMASK","PAGEMASK",5,0},
	{mXc0,0,"C0_WIRED","WIRED",6,0},
	{mXc0,0,"C0_COUNT","COUNT",9,0},
	{mXc0,0,"C0_COMPARE","COMPARE",11,0},
	{mXc0,0,"C0_LLADR","LLADR",17,0},
	{mXc0,0,"C0_BPC","BPC",18,0},
	{mXc0,0,"C0_BDA","BDA",19,0},
	{mXc0,0,"C0_BPCM","BPCM",20,0},
	{mXc0,0,"C0_BDAM","BDAM",21,0},
	{mXc0,0,"C0_ROTATE","ROTATE",23,0},
	{mXc0,0,"C0_CMASK","CMASK",24,0},
	{mXc0,0,"C0_ERREPC","ERREPC",30,0},
	{0}};

int cache_cmd_401x();
extern Optdesc cache_opts_401x[];

CmdRec cmdlist[] = {
	{"cache",cache_opts_401x,cache_cmd_401x},
	{0}};

/*************************************************************
*  dvrInit()
*/
dvrInit()
{
int i;

ice_baud = B38400; /* baud is a don't care for the iceport */
ice_device = "/dev/tty2"; /* tty2 is the iceport */
for (i=0;reglist[i].func;i++) addRegRec(&reglist[i]);
addicecmds();
for (i=0;cmdlist[i].name;i++) addCmdRec(&cmdlist[i]);
need_initial_flush = 1;
init_4011();
}
#endif

void init_4011(void)
{
flush_target_ptr = flush_target_401x;
brkInstall_ptr = brkInstall_401x;
ilockReq_ptr = ilockReq_401x;
brkRemove_ptr = brkRemove_401x;
setFlushneeded_ptr = setFlushneeded_401x;

_cputype = 4011;
/* cache size is configurable. 16KB is the maximum size. */
icache_size = 16*1024;
dcache_size = 16*1024;
cache_line_size = 32; /* bytes per line */
has_wb_dcache = 1;
has_ilock = 1;
has_nhwdb = 1;
has_nhwib = 1;
}

