/*************************************************************
 * File: bsps/accesstst.s
 * Purpose: Example Ocm access routine
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	980323	Start of revision history
 *	980323	Corrected typo. globl not global.
 *	980811	Fixed prob w trashing AT.
 */

/*************************************************************
This is an example ocm access routine for use with serialice1.dll.  Ocm
regions do not require an access routine, but you need to provide one if
access to your Ocm region requires that a special procedure be followed.

This example contains no special access procedure but it can be used as
a template for the functions that you need to provide.  The number of
registers that are available as temps depends on how many are saved in
your serialIce kernel (see regmap function below).  However, you must
not use t0 and t1.  It is safest to start with t2.  Your SerialIce
kernel must use the new style savearea format.  Just look for ICE_MAP.

The argument 'mode' has three possible values:

	0.  Read. In this case 'value' is a don't care.
	1.  Write.
	2.  Regmap. You must return a value that has a bit set
	    for every register you are using. eg. If you are using
	    registers a0..a3, and AT. Then the value you return will
	    be 0x000000f2. In this case 'addr', 'sz', and 'value' are
	    all don't cares.
	3.  Function size. You must return the size of the function
	    in bytes in v0 (not a0). This is only used in the IMON
	    configuration. It is called from C, which is why it must
	    have a "j ra".

The argument 'sz' has three possible values:

	1.  Byte operation (8-bits).
	2.  Halfword operation (16-bits).
	4.  Word operation (32-bits).

For use with IMON, you must link it with the driver, and install it with
the addOcmRec() function. See d4101.c for an example.

For use with the DLL you must convert this file into the .ocm format.
See the makefile rule below:

accesstst.ocm : accesstst.s
	pmcc -crt0 -o accesstst accesstst.s
	rdsrec -m accesstst.rec > accesstst.ocm

*************************************************************/
#include <mips.h>

#ifndef LABEL
#define LABEL _start
#endif

/*************************************************************
*  accesstst(int mode,Ulong addr,int sz, Ulong value)
*                a0          a1     a2        a3       result=a0
*	feprom access routine.
*/

	.globl LABEL
	.ent LABEL
LABEL:
	li	v0,3		# 980811
	bne	a0,v0,2f	# brif not funcsize
   	# must be funcsize
	la	v0,9f
	la	t2,LABEL
	subu	v0,t2
	srl	v0,2		# return value is words
	j	ra		# return value must be in v0

   2:	# read?
	bne	a0,zero,2f	# brif not read

	# read
	# use sz to select one of the following:
	bne	a2,1,1f
	lbu	a0,(a1)
	b	3f

   1:	bne	a2,2,1f
	lhu	a0,(a1)
	b	3f

   1:	# must be sz=4
   	lw	a0,(a1)
	b	3f

   2:	# write?
	li	v0,1		# 980811
   	bne	a0,v0,2f	# brif not write

   	# write
	# use sz to select one of the following:
	bne	a2,1,1f
	sb	a3,(a1)
	b	3f

   1:	bne	a2,2,1f
   	sh	a3,(a1)
	b	3f

   1:	# must be sz=4
   	sw	a3,(a1)
	b	3f

   2:	# must be regmap
   	li	a0,0x000004f2	# regs required by this routine
				# AT,a0-a3,t2
	# fall thru
   3:
   9:
	# a subroutine return is not required
	# It will be appended by the SerialIce kernel
   	.end LABEL

