/******************************************************************/
/* Copyright (c) 2002 BRECIS Communications                       */
/*      This software is the property of BRECIS Communications    */
/*      and may not be copied or distributed in any form without  */
/*      a prior licensing arrangement.                            */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/

/* manufinfo - generate manufacturing info */

/* invocation - manufinfo key1=value1 key2=value2 ... keyn=valuen

   Example:
   ./manufinfo ethaddr0=00:02:d8:00:01:9f \
   ethaddr1=00:02:d8:00:01:a0 ethaddr2=00:02:d8:00:01:a1 > xxx 
*/

#include <stdio.h>
#include <netinet/in.h>
#include "flashconfig.h"

struct keyvalue {
	unsigned char key;
	char *name;
	char *help;
};

struct keyvalue keyValues[] = {
	{FLASHCONFIG_SERIAL, "serialno", 
	 "Serial number"},
	{FLASHCONFIG_ETHERMAC0, "ethaddr0", 
	 "Ethernet hardware MAC 0 address"},
	{FLASHCONFIG_ETHERMAC1, "ethaddr1",
	 "Ethernet hardware MAC 1 address"},
	{FLASHCONFIG_ETHERMAC2, "ethaddr2",
	 "Ethernet hardware MAC 2 address"},
	{FLASHCONFIG_ETHERPHY0, "phyaddr0", 
	 "Ethernet hardware PHY 0 address"},
	{FLASHCONFIG_ETHERPHY1, "phyaddr1",
	 "Ethernet hardware PHY 1 address"},
	{FLASHCONFIG_ETHERPHY2, "phyaddr2",
	 "Ethernet hardware PHY 2 address"},
	{FLASHCONFIG_ZERO, ""}
};

main(int argc, char **argv)
{
	unsigned long crc;
	int	i;
	int	j;
	int	len;
	unsigned int number[6];
	char buf[200];
	char *bptr, *bbptr;
	char *ptr;
	struct keyvalue *key;
	flashConfigPtr *flashConfig;
	
	if (argc < 2)
	{
		fprintf(stderr, 
			"usage: %s key1=value1 key2=value2 ... keyn=valuen\n", 
			argv[0]);
		fprintf(stderr, "where keyn can be any of the following:\n");
		key = keyValues;
		while (key->key != FLASHCONFIG_ZERO)
		{
			fprintf(stderr, "%8s%8s%8s%s\n", 
				"", key->name, "", key->help);
			key++;
		}
		fprintf(stderr, "\n example:\n ./manufinfo ethaddr0=00:02:d8:00:01:9f ethaddr1=00:02:d8:00:01:a0 ethaddr2=00:02:d8:00:01:a1 > xxx\n\n");
		return 1;
	}
	
	flashConfig = (flashConfigPtr *) buf;
	bptr = bbptr = (char *) &flashConfig[1];
	
	for (i = 1; i < argc; i++)
	{
		ptr = (char *) index(argv[i], '=');
		
		if (ptr == NULL)
		{
			fprintf(stderr,
				"Parameter %d:%s does not have an '='\n", 
				i, argv[i]);
			continue;
		}
		
		key = keyValues;
		
		*ptr++ = '\0';	/* zero out the '=' character */
		
		while (key->key != FLASHCONFIG_ZERO)
		{
			if (strcmp(argv[i], key->name) == 0)
			{
				break;
			}
			
			key++;
		}
		
		if (key->key == FLASHCONFIG_ZERO)
		{
			fprintf(stderr, "Key <%s> not found: %s=%s\n", 
				argv[i], argv[i], ptr);
			continue;
		}
		
		if (key->key == FLASHCONFIG_ETHERMAC0 ||
		    key->key == FLASHCONFIG_ETHERMAC1 ||
		    key->key == FLASHCONFIG_ETHERMAC2)
		{
			if (sscanf(ptr, "%02x:%02x:%02x:%02x:%02x:%02x",
				   &number[0], &number[1], &number[2], 
				   &number[3], &number[4], &number[5]) != 6)
			{
				fprintf(stderr, 
					"MAC string %s=%s, bad address\n",
					argv[i], ptr);
				continue;
			}
			
			*bptr++ = key->key;
			*bptr++ = 6;
			for (j = 0; j < 6; j++)
			{
				*bptr++ = number[j];
			}
			continue;
		}

		*bptr++ = key->key;
		*bptr++ = len = strlen(ptr);
		for (j = 0; j < len; j++)
			*bptr++ = *ptr++;
	}
	
	flashConfig->length = ntohs((signed short)(bptr - bbptr));
	flashConfig->offset = ntohs((signed short)(sizeof(flashConfigPtr)));
	
	crc = crc32_payload_begin((unsigned char *) flashConfig,
				  sizeof(signed short) + sizeof(signed short));
	
	crc = crc32_payload_end(crc, (unsigned char *) bbptr,
				bptr - bbptr);
	
	flashConfig->crc = ntohl(crc);
	
	for (i = 0; i < bptr - buf; i++)
		fprintf(stdout, "%c", buf[i]);

	return 0;
}
