#include "mips.h"
#include "defines.h"

#define UART_BASE	0xBC000100	/* Base address to UART            */
#define NSREG(x) ((x)*4)
#define DATA (NSREG(0))	/* data register (R/W)             */
#define IER  (NSREG(1))	/* interrupt enable (W)            */
#define IIR  (NSREG(2))	/* interrupt identification (R)    */
#define	FIFO (NSREG(2))	/* 16550 fifo control (W)          */
#define CFCR (NSREG(3))	/* line control register (R/W)     */
#define MCR  (NSREG(4))	/* modem control register (R/W)    */
#define LSR  (NSREG(5))	/* line status register (R/W)      */
#define MSR  (NSREG(6))	/* modem status register (R/W)     */
#define SCR  (NSREG(7))	/* scratch register (R/W)          */

#define LSR_TXRDY       0x20    /* transmitter ready */

/**********************************************/
/*  Output String out to console			  */
/**********************************************/
	.globl serial_out
	.ent serial_out

serial_out:
	li	t0,UART_BASE
10:
	lbu	t1,0(a0)	/* read first char location */
	beqz t1,20f
		
	lw	t2,LSR(t0)	/* Read LSR see character ready */
	and	t2,LSR_TXRDY

	beqz  t2,10b

	sw	t1,DATA(t0)
	addu a0,a0,1
	b	10b

20:
	j	ra
	.end serial_out
		
