/*************************************************************
 * File: lib/str_fmt.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include "string.h"
#include "strfmt.h"

extern char *strichr(char *p, int c);

/** str_fmt(p,size,fmt) format p in a field size in width using fmt */
void str_fmt(p,size,fmt)
char *p;
int size,fmt;
{
int n,m,len;

len = strlen(p);
switch (fmt) {
	case FMT_RJUST :
		for (n=size-len;n>0;n--) strichr(p,' ');
		break;
	case FMT_LJUST :
		for (m=size-len;m>0;m--) strcat(p," ");
		break;
	case FMT_RJUST0 :
		for (n=size-len;n>0;n--) strichr(p,'0');
		break;
	case FMT_CENTER :
		m = (size-len)/2;
		n = size - (len+m);
		for (;m>0;m--) strcat(p," ");
		for (;n>0;n--) strichr(p,' ');
		break;
	}
}

