/*************************************************************
 * File: pmon/mips.s
 * Purpose: startup code for PMON
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	970313	changed jal to jalr for EPI tools
 *	970530	Changed DCACHEI to DCACHE. Could lose data on 4010.
 *	971212	Always copy handler to debug exception vector
 *	980203	Restored 64008 ifdef to reset_exception
 *	980703	Replaced hostInit(0) with cpuInit()
 *	980703	Added code to save cpuType after cpuInit is called.
 */

/*
 *	The contents of this file are not copyrighted in any
 *	way, and may therefore be used without restriction.
 */

#include "mips.h"
#include "defines.h"

/*
 * If you are new to MIPS assembly language programming, you will find
 * the following texts useful:
 *
 * "MIPS Risc Architecture", by Jerry Kane, published by Prentice Hall,
 *  ISBN 0-13-584749-4.
 *
 * "MIPS Programmer's Handbook", by Erin Farquhar and Philip Bunce,
 * published by Morgan Kaufmann, ISBN 1-55860-297-6.
 *
 */

/* needed for r4000 mode */
#define eret    .word 0x42000018        /* could use -mips2 sw */

#define NEWMEMSIZE

	.text

reset_exception:
        la      k0,_start
	or      k0,K1BASE
	j       k0
	.align  8

	.align  9	/* bfc00200 Other general */
	la	k0,_exception
	li	k1,K1BASE
	or	k0,k1
	j	k0

	.align  7	/* bfc00280 XTLB refill */
	la	k0,_exception
	li	k1,K1BASE
	or	k0,k1
	j	k0

	.align  8	/* bfc00300 Cache error */
	la	k0,_exception
	li	k1,K1BASE
	or	k0,k1
	j	k0

	.align  7	/* bfc00380 Others (general) */
	la	k0,_exception
	li	k1,K1BASE
	or	k0,k1
	j	k0

	.align  10	/* bfc00400 */
	addu	zero,zero,zero
		
	.align  7	/* bfc00480 - Debug with probtrap - 0 in ECR */
	la	k0,_exception
	li	k1,K1BASE
	or	k0,k1
	j	k0

	.align  8	/* bfc00500 start of entry pt table */

	.comm	topClientMem,4
	.comm	topRealMem,4
	.comm	uart_freq,4
	.comm	DBGREG,NREGS*4

/*************************************************************
*  _start:
*	This is the entry point of the entire PROM Monitor
*/
	.globl _start
	.ent _start
_start:

	# set SR and CAUSE to something sensible
	.set noreorder
	.set noat
	mtc0	zero,$18	# C0_WATCHLO
	nop
	mtc0	zero,$19	# C0_WATCHHI
	nop
	li	v0,(SR_BEV|SR_IMASK|SR_EXL)
	nop
	mtc0	v0,C0_SR
	nop
	mtc0	zero,C0_CAUSE
	nop
	.set at
	.set reorder

	/* upon exit, a5000init returns
	 * v0 - memory size
	 * s0 - address of cache invalidate routine
	 */
	jal	a5000init
	move	s2, v0		/* save size of memory */

	# flush the dcache
	li      a0,DCACHEI
	or	s0,K1BASE
	jal     s0

	li	a0,ICACHEI
	jal	s0

	jal	cpdata
	jal clrbbloadbss

	# copy handler
	la      a0,handler
	la      a1,ehandler
	li      a2,0x80000000           # utlb miss
	jal     copyHandler

/* always copy this. But sometimes it's pointless */
	li      a2,0x80000040           # debug 
	jal     copyHandler

	li      a2,0x80000080           # general vector
	jal     copyHandler

	la      a0,handler
	la      a1,ehandler
	li      a2,0x80000180           # general exception vector
	jal     copyHandler

	# flush the caches
	li	a0,DCACHE	# 970530
	jal	s0

	li	a0,ICACHE
	jal	s0

	sw	k1, uart_freq	# Save uart clock frequency

	# save memory size
	sw	s2,topClientMem
	sw	s2,topRealMem

	# Add by hook 2003/05/30

	.set noreorder

	li     t0,0xb84000e0 # GPIO Data Register
	lw     t1,(t0)
	li	   t0,0x80000ffc
	sw     t1,(t0)       # save GPIOData for later use

#   li      t0,0xb84000e4  # GPIO CFG1
#   li  	t1,0x00000088
#   sw      t1,(t0)

#   li      t0,0xb84000e0 # GPIO Data Register
#   lw      t1,(t0)
#   and     t1,t1,0x0     # set 0 to turn on led
#   sw      t1,(t0)

	li      t0,0xb84000e4  # GPIO CFG1
	li      t1,0x08000000
	sw     t1,(t0)

	.set reorder

	# end of added by Max
	
	# ints might be enabled from here on

	#########################################################
	#	Set initial client conditions			#
	#
	la	s1,DBGREG
	la	v0,ftext		/* ram kernel starts with first address */
	sw	v0,R_PC*4(s1)
	jal	clienttos
	sw	v0,R_SP*4(s1)
	move sp,v0			# use client stack for bbload
	sw	zero,R_A3*4(s1)	# prom (no prom routines at moment)
	la	t1,envp
	sw	t1,R_A2*4(s1)	# envp
	la	t1,argv
	sw	t1,R_A1*4(s1)	# argv
	jal	setupcallargs
	sw	v0,R_A0*4(s1)	# argc
/*	jal	setQFlush	*/	/* mark by hook 2003.05.30*/
	lw	v0, pcsetflag
	bnez	v0, 1f
	jal	cptext			# copy kernel text from flash to SDRAM
1:
#if 0	/* in the boot loader, we do not have a gp pointer */
	la	v0, _gp
	sw	v0,R_GP*4(s1)	# gp pointer
#endif

	.set noreorder
 	mfc0	v0,C0_SR
 	nop

	# clear BEV
	# Do not clear BEV bit for 64388 because 0x80000000 does not exist.
  	li	t0,~SR_BEV
  	and	v0,t0
 	mtc0	v0,C0_SR

	sw	v0,R_STATUS*4(s1)
	.set reorder

	#							#
	#########################################################
#if 0 /* maybe never */
	la	t1,relocAddr
	lw	t1,(t1)
	la	t0,monmain		
	subu t0,t1
	jal	t0		# transfer to main part of PMON
#endif
#if 0
	la	k0,DBGREG
	lw	k1,R_PC*4(k0)
	move	a0, k1
	jal	a5000PrintWordReg
	nop
#endif

	/* CAUTION: we jump to _go to start executing in RAM.
	 * C Code in RAM MUST use an indirect jump to get to code in ROM.
	 * Assembler code in RAM must either go through the indirect jump 
	 * table used by C Code -or- must do 
	 * la t0,routinename
	 * jalr t0
	 * to get to code in ROM.
	 * The SAME is true in the other direction for code going from
	 * ROM to RAM.
	 *
	 */
	j	_go
	.end _start

/*************************************************************
*  handler:
*	This is the handler that gets copied to the exception vector 
*	addresses.
*/
	.globl handler
	.ent handler
handler:
	.set noat
	la	k0,_exception
	j	k0
ehandler:
	.set at
	.end handler

/*************************************************************
*  _go:
*	This routine is used to transfer control to a client program.
*/
	.globl	_go
	.ent _go
_go:
	la	k0,DBGREG
	# restored later		/* $1  (at) */
	lw	v0,R_V0*4(k0)		/* $2  (v0) */
	lw	v1,R_V1*4(k0)		/* $3  (v1) */
	lw	a0,R_A0*4(k0)		/* $4  (a0) */
	lw	a1,R_A1*4(k0)		/* $5  (a1) */
	lw	a2,R_A2*4(k0)		/* $6  (a2) */
	lw	a3,R_A3*4(k0)		/* $7  (a3) */
	# restored later		/* $8  (t0) */
	lw	t1,R_T1*4(k0)		/* $9  (t1) */
	lw	t2,R_T2*4(k0)		/* $10 (t2) */
	lw	t3,R_T3*4(k0)		/* $11 (t3) */
	lw	t4,R_T4*4(k0)		/* $12 (t4) */
	lw	t5,R_T5*4(k0)		/* $13 (t5) */
	lw	t6,R_T6*4(k0)		/* $14 (t6) */
	lw	t7,R_T7*4(k0)		/* $15 (t7) */
	lw	s0,R_S0*4(k0)		/* $16 (s0) */
	lw	s1,R_S1*4(k0)		/* $17 (s1) */
	lw	s2,R_S2*4(k0)		/* $18 (s2) */
	lw	s3,R_S3*4(k0)		/* $19 (s3) */
	lw	s4,R_S4*4(k0)		/* $20 (s4) */
	lw	s5,R_S5*4(k0)		/* $21 (s5) */
	lw	s6,R_S6*4(k0)		/* $22 (s6) */
	lw	s7,R_S7*4(k0)		/* $23 (s7) */
	lw	t8,R_T8*4(k0)		/* $24 (t8) */
	lw	t9,R_T9*4(k0)		/* $25 (t9) */
					/* $26 (k0) */
					/* $27 (k1) */
	lw	gp,R_GP*4(k0)		/* $28 (gp) */
	lw	sp,R_SP*4(k0)		/* $29 (sp) */
	lw	s8,R_FP*4(k0)		/* $30 (s8) */
	lw	ra,R_RA*4(k0)		/* $31 (ra) */

 # If the mthi/mtlo are emulated k0 gets overwritten have to reload it
 # the .noreorder is because the assembler doesn't know about the
 # dependency between mtlo and la k0 and swaps them.

       .set noreorder
	lw	k1,R_HI*4(k0)		/* Hi */
        nop
        mthi    k1
        la      k0,DBGREG
        lw      k1,R_LO*4(k0)           /* Lo */
        nop
        mtlo    k1
        la      k0,DBGREG
        .set reorder

	.set noreorder
	.set noat

	lw	k1,R_STATUS*4(k0)	# get Status
	nop
	or	k1,(1<<1)		# SR_EXL
	mtc0	k1,C0_SR		# set SR
	nop

	lw	k1,R_K1*4(k0)		/* $27 (k1) */
	lw	t0,R_T0*4(k0)		/* $8  (t0) */
	lw	AT,R_AT*4(k0)		/* $1  (AT) */
	lw	k0,R_PC*4(k0)		/* PC */
	nop
	
	la      k0,eromtext		/* hsujp */
	mtc0	k0,C0_EPC
	# I don't know exactly how many nops you need here. But is
	# certainly more than one.
	nop
	nop
	nop
	nop
	nop
	eret
	nop
	.set at
	.set reorder
	.end _go

/*************************************************************
*  _exception:
*	This routine is used to save the state of a client program after
*	an exception is encountered. But it first checks to see if there
*	is a user defined exception handler (via onintr), and then checks
*	to see if it's a floating-point instruction (if PMON has fp emulation
*	enabled.)
*/
	.globl	_exception
	.ent _exception
_exception:
	.set noat
	la	k0,DBGREG
	sw	k1,R_K1TMP*4(k0)

exc2:

1:	la	k0,DBGREG
	lw	k1,R_K1TMP*4(k0)	# restore k1
	sw	k1,R_K1*4(k0)		/* $27 (k1) */
	sw	AT,R_AT*4(k0)		/* $1  (AT) */
	.set at
	sw	zero, R_ZERO*4(k0)	/* $0  (zero) - I know it is always zero */	
	sw	v0,R_V0*4(k0)		/* $2  (v0) */
	sw	v1,R_V1*4(k0)		/* $3  (v1) */
	sw	a0,R_A0*4(k0)		/* $4  (a0) */
	sw	a1,R_A1*4(k0)		/* $5  (a1) */
	sw	a2,R_A2*4(k0)		/* $6  (a2) */
	sw	a3,R_A3*4(k0)		/* $7  (a3) */
	sw	t0,R_T0*4(k0)		/* $8  (t0) */
	sw	t1,R_T1*4(k0)		/* $9  (t1) */
	sw	t2,R_T2*4(k0)		/* $10 (t2) */
	sw	t3,R_T3*4(k0)		/* $11 (t3) */
	sw	t4,R_T4*4(k0)		/* $12 (t4) */
	sw	t5,R_T5*4(k0)		/* $13 (t5) */
	sw	t6,R_T6*4(k0)		/* $14 (t6) */
	sw	t7,R_T7*4(k0)		/* $15 (t7) */
	sw	s0,R_S0*4(k0)		/* $16 (s0) */
	sw	s1,R_S1*4(k0)		/* $17 (s1) */
	sw	s2,R_S2*4(k0)		/* $18 (s2) */
	sw	s3,R_S3*4(k0)		/* $19 (s3) */
	sw	s4,R_S4*4(k0)		/* $20 (s4) */
	sw	s5,R_S5*4(k0)		/* $21 (s5) */
	sw	s6,R_S6*4(k0)		/* $22 (s6) */
	sw	s7,R_S7*4(k0)		/* $23 (s7) */
	sw	t8,R_T8*4(k0)		/* $24 (t8) */
	sw	t9,R_T9*4(k0)		/* $25 (t9) */
					/* $26 (k0) */
	sw	gp,R_GP*4(k0)		/* $28 (gp) */
	sw	sp,R_SP*4(k0)		/* $29 (sp) */
	sw	s8,R_FP*4(k0)		/* $30 (s8) */
	sw	ra,R_RA*4(k0)		/* $31 (ra) */
	.set noreorder

	mfc0	k1,C0_SR		# get current SR value
	nop
	and	k1,~(1<<1)		# SR_EXL
	sw	k1,R_STATUS*4(k0)	# $34 save Status

        mfc0    k1,C0_CAUSE
        nop
        sw      k1,R_CAUSE*4(k0)        /* $37 Cause */
        mfc0    k1,C0_EPC
        nop
        sw      k1,R_PC*4(k0)          /* $35 EPC */
        mfc0    k1,C0_BADVADDR
        nop
        sw      k1,R_BADVA*4(k0)        /* $38 BadVA */
        mfc0    k1,C0_ErrorEPC
        nop
        sw      k1,R_ERROREPC*4(k0)     /* $39 ErrorEPC */
	.set reorder
	
 # 970404 moved to be after C0_CAUSE because emulated mfhi/mflo 
 # obscures the cause and epc reg
	mfhi	k1
	sw	k1,R_HI*4(k0)		/* $32 Hi */
	mflo	k1
	sw	k1,R_LO*4(k0)		/* $33 Lo */
		
	la	sp,0x1000		/* set up a stack just in case */
	la	t0,exception
	j	t0

	.end _exception

/*************************************************************
*  clienttos()
*	This routine returns the correct top-of-stack value.
*	Used by C routines, when they need to set the client stack pointer.
*/
	.globl clienttos
	.ent clienttos
clienttos:
#ifdef NEWMEMSIZE
	la	t0,topClientMem
	lw	v0,(t0)
#else
	la	t0,memorysize
	lw	v0,(t0)
	addu	v0,CLIENTPC
#endif
	and	v0,~7 			# double word align
	subu	v0,24			# make room for a0-a3..
	or		v0, K0BASE	# stack should be in the k0seg	
	j	ra
	.end clienttos

/*************************************************************
*  disableints()
*	This is used make sure that interrupts are disabled.
*/
	.globl disableints
	.ent disableints
disableints:
	.set noreorder
	mfc0	t0,C0_SR
	nop
	and	t0,~SR_IEC
	mtc0	t0,C0_SR
	.set reorder
	j	ra
	.end disableints

/*************************************************************
*  copyHandler:
*	Used to copy the exception handler to the various
*	vector addresses.
*/

	.globl copyHandler
	.ent copyHandler
copyHandler:
	# a0=src a1=end a2=dst
	# must not change a0 or a1
	# must force a0 & a1 to kseg1
	or      t0,a0,K1BASE
	or      t1,a1,K1BASE
1:      lw      v0,(t0)
	sw      v0,(a2)
	addu    t0,4
	addu    a2,4
	blt     t0,t1,1b
	j       ra
	.end copyHandler

	.align	2	

