/*************************************************************
 * File: defines.h
 * Purpose: Define constants
 *          Caution: changing these constants may cause problems.
 *          Please be careful when changing these constants.
 */

/*
 * CAUTION: the following are the clock rate for the hardware.
 *          Remember to change both the CLOCK_RATE and the CLOCK_VAL.
 */

#define CPU_CLOCK_RATE	        150000000			/* 150 Mhz */
#define CPU_CLOCK_VAL			0x78				/* Parmeter value */

#define DRAM_CLOCK_RATE	       125000000			/* 125 Mhz Mega 	*/
#define DRAM_CLOCK_VAL			0x64				/* Parmeter value   */

#if 0 	/* hook add 20030603 */
#define DRAM_CLOCK_RATE	       100000000			/* 100 Mhz Mega 	*/
#define DRAM_CLOCK_VAL			0x50				/* Parmeter value   */
#define DRAM_CLOCK_RATE	       150000000			/* 150 Mhz Mega 	*/
#define DRAM_CLOCK_VAL			0x78				/* Parmeter value   */
#endif

#define SLM_CLOCK_RATE	        50000000			/* 50 Mhz Mega 	*/
#define SLM_CLOCK_VAL			0x28				/* Parmeter value   */

#define PE_CLOCK_RATE	        100000000			/* 100 Mhz Mega 	*/
#define PE_CLOCK_VAL			0x50				/* Parmeter value   */

#define VE_CLOCK_RATE	        1000000000			/* 100 Mhz Mega 	*/
#define VE_CLOCK_VAL			0x50				/* Parmeter value   */

#define PER_CLOCK_RATE	        25000000			/* 25 Mhz Mega 	*/
#define PER_CLOCK_VAL			0x14				/* Parmeter value   */

#define PLL0_DIV_RATE_POLO		400000000
#define PLL0_DIV_VAL_POLO		16

#define PLL1_DIV_RATE_POLO		500000000
#define PLL1_DIV_VAL_POLO		20

#define CPU_CLOCK_RATE_POLO     166666667			/* 167 Mhz */
#define CPU_CLOCK_VAL_POLO		6

#define SEC_CLOCK_VAL_POLO		0xff				/* For Polo 2005/2007 */

#ifndef LANGUAGE_ASSEMBLY
/* 
 * define constants for setting up the call arguments.
 * The values below affect how much SDRAM bbload needs which in
 * turn affects the possible starting load address for the kernel.
 *
 * Please always check bbload's SDRAM requirements after building bbload
 * even if these values are not changed since changing code or using a
 * different compiler might produce different SDRAM requirements.
 */
#define MAXARGC			21		/* maximum argc (pointers + zero pointer) */
#define MAXCMDLINE		257		/* maximum command line length + zero byte */
#define MAXENVP			21		/* maximum number envp pointers + zero ptr */
#define	MAXENVPAREA		500		/* enpv area data (variable names + values) */

extern char *argv[];			/* global location for argv pointer array */
extern char *envp[];			/* global location for envp pointer array */
#endif

#define FLASHCFGSTRING	"#!/bin/bbload"
#define FLASHCMDSET		"set"
#define FLASHCMDSETARGS	"setargs"
#define FLASHCMDSETPC	"setpc"
#define FLASHCFGENDSTR	"#!eof"
#define CRLF			"\n\r"
#define FLASHCFG	0xbfc10000	/* flash location of configuration info */
#define FLASHCFGMAXLEN	0x10000

#define NULL	(void *) 0

/* #define DEBUGBOOT */
