/*************************************************************
 * File: include/brecis.h
 * Purpose: Define BRECIS hardware related items
 */

#ifndef _BRECIS_H_
#define _BRECIS_H_

#define FEATURES "features"

#define CPU_DEVID_MIIPCIDISABLED	(0x04000000)
#define CPU_DEVID_MIIMACMODE		(0x18000000)
#define CPU_DEVID_PCIHOST			(0x00100000)	
#define CPU_DEVID_PCIMUXMODE		(0x00080000)
#define CPU_DEVID_SUBFAMILY			(0x00070000)
#define CPU_DEVID_FAMILY			(0x0000ff00)
#define CPU_DEVID_REVISION			(0x000000ff)

#define FPGA_IS_ZEUS(revision)	((revision < 0x80))
#define FPGA_IS_POLO(revision)	((revision >= 0xb0))
#define FPGA_IS_5000(revision)	((revision >= 0x80 ) && (revision < 0x90))
#define FPGA_IS_DUET(revision)	(((revision >= 0xa0) && (revision < 0xb0)))

#define DUET_REVA				0x01

#define POLO_SUBFAMILY_2005		0x01
#define POLO_SUBFAMILY_2007		0x02
#define POLO_SUBFAMILY_2010		0x03
#define POLO_SUBFAMILY_2020		0x05
#define POLO_SUBFAMILY_2100		0x06

#define FAMILY_FPGA		0x0000
#define	FAMILY_ZEUS		0x1000
#define FAMILY_POLO		0x2000
#define FAMILY_DUET		0x4000
#define FAMILY_TRIAD	0x5000

#define MAX_POLO_ENET_INTERFACES	3

/* Use the following to create a string of features of the form:
 * <key><flag><key><flag>...
 * where key can be any of the xxx_KEY
 * and flag can be FEATURE_EXIST, FEATURE_NOEXIST, or special character.
 * <key> can occur more than once in a string such as ethernet where more
 * than one ethernet interface can exist (or not exist) as the case may be.
 */
#define ENET_KEY		'E'
#define ENETTXD_KEY		'e'
#define PCI_KEY			'P'
#define PCIMUX_KEY		'p'
#define SEC_KEY			'S'
#define SPAD_KEY		'D'
#define TDM_KEY			'T'
#define ZSP_KEY			'Z'

#define FEATURE_NOEXIST	'-'
#define FEATURE_EXIST	'+'

#define ENET_MII		'M'
#define ENET_RMII		'R'

#define	ENETTXD_FALLING	'F'
#define ENETTXD_RISING	'R'

#define PCI_HOST		'H'
#define PCI_PERIPHERAL	'P'

#define PCIMUX_FULL		'F'
#define PCIMUX_SINGLE	'S'

#define SEC_DUET		'D'
#define SEC_POLO		'P'
#define SEC_SLOW		'S'
#define SEC_TRIAD		'T'

#define SPAD_POLO		'P'

#define TDM_DUET		'D'		/* DUET TDMs might exist */
#define TDM_POLO		'P'		/* POLO TDMs might exist */
#define TDM_TRIAD		'T'		/* TRIAD TDMs might exist */

#define ZSP_DUET		'D'		/* one DUET zsp engine */
#define ZSP_TRIAD		'T'		/* two TRIAD zsp engines */

/*--------------------------------------------------------------------------*/
/* MIPS Interrupt Cause Register C0_CAUSE				    				*/
/* 15  14  13  12  11 10  9  8						    					*/
/* |   |   |   |   |  |   |  |						    					*/
/* |   |   |   |   |  |   |  --> IP 0 = Software Interrupt 0		    	*/
/* |   |   |   |   |  |   -----> IP 1 = Software Interrupt 1		    	*/
/* |   |   |   |   |  ---------> IP 2 = INT0: MAC 0					    	*/
/* |   |   |   |   ------------> IP 3 = INT1: MAC 1				    		*/
/* |   |   |   ----------------> IP 4 = INT2: VE, FE or SEC Programable     */
/* |   |   --------------------> IP 5 = INT3: VE, FE or SEC Programable	    */
/* |   ------------------------> IP 6 = INT4: SLM				    		*/
/* ----------------------------> IP 7 = INT5: MIPS Timer			        */
/*--------------------------------------------------------------------------*/
#define	SW0_INT_ID	SR_IBIT1			/* Sw0 interrupt ID */
#define SW1_INT_ID	SR_IBIT2			/* SW1 interrupt ID */

#define INT_MAC0_ID	SR_IBIT3			/* MAC0 Interrupt ID */
#define INT_MAC1_ID	SR_IBIT4			/* MAC1 Interrupt ID */
#define INT_VFS_ID2	SR_IBIT5			/* VOICE, FE OR SEC  Interrupt ID Option 2*/
#define INT_VFS_ID3	SR_IBIT6		   	/* VOICE, FE OR SEC  Interrupt ID Option 3*/
#define INT_SLM_ID  SR_IBIT7			/* SLM  Interrupt ID */
#define INT_COU_ID	SR_IBIT8			/* MIPS INTERNAL TIMER INTERRUPT */

		
#define	MEM_CTL_BASE	0xB7F00000	/* Base address to memory contlr   */
#define MEM_CNFG_REG	(MEM_CTL_BASE + 0x00)	/* memory configuration reg */
#define MEM_RFT_REG		(MEM_CTL_BASE + 0x04)	/* refresh timer reg */
#define MEM_RFC_REG		(MEM_CTL_BASE + 0x08)	/* refresh counter reg */
#define MEM_TMGM_REG	(MEM_CTL_BASE + 0x0C)	/* Timing param reg */
#define MEM_INIT_REG	(MEM_CTL_BASE + 0x10)	/* initialization reg */
#ifndef LANGUAGE_ASSEMBLY
/* Queue Flush Register 1 */
#define QFLUSH_REG_1 ((volatile unsigned int *) (MEM_CTL_BASE + 0x40000))
#define QFLUSH_PCI_BIT	0x02			/* if set, flush PCI data queue */
#define QFLUSH_SCR_BIT	0x01			/* if set, flush scratch RAM queue */
#endif
#define SDRAMADDRESS	0xa0000000		/* first address non-cached sdram */
		
#define	SREG_BASE	0xBC000000	/* Base address to SLM Block       */
#define	DEV_ID_REG	(SREG_BASE + 0x000)  /* Device-ID Register         */
#define	FWR_ID_REG	(SREG_BASE + 0x004)  /* Firmware-ID Register       */
#define	SYS_RST_REG	(SREG_BASE + 0x010)  /* system Reset Status Register RO */
#define	RST_SET_REG	(SREG_BASE + 0x014)  /* System set Reset Register    WO */
#define	RST_CLR_REG	(SREG_BASE + 0x018)  /* System Clear Reset Register  WO */
#define	PCM0_CLK_REG	(SREG_BASE + 0x020)  /* PCM0 Clock Generator       */
#define	PCM1_CLK_REG	(SREG_BASE + 0x024)  /* PCM1 Clock Generator       */
#define	PCM2_CLK_REG	(SREG_BASE + 0x028)  /* PCM2 Clock Generator       */
#define PCM3_CLK_REG	(SREG_BASE + 0x02C)  /* PCM3 Clock Generator	   */
#define	PLL1_DIV_REG	(SREG_BASE + 0x02C)  /* PLL1 Divider Value         */
#define	PLL0_DIV_REG	(SREG_BASE + 0x030)  /* PLL0 Divider Value         */
#define	MIPS_CLK_REG	(SREG_BASE + 0x034)  /* MIPS Clock Generator       */
#define	VE_CLK_REG	(SREG_BASE + 0x038)  /* Voice Engine Clock Gen     */
#define	FE_CLK_REG	(SREG_BASE + 0x03C)  /* Framer Engine Clock Gen    */
#define SEC_CLK_REG (SREG_BASE + 0x3C)		/* Polo SEC clock engine */
#define	DVB_CLK_REG	(SREG_BASE + 0x040)  /* DV-Bus Clock Generator     */
#define	SMAC_CLK_REG	(SREG_BASE + 0x044)  /* SEC & MAC Clock Generator  */
#define	PERF_CLK_REG	(SREG_BASE + 0x048)  /* Peripheral & ADPCM Clk Gen */
#define	INT_STA_REG	(SREG_BASE + 0x070)  /* Interrupt Status Register  */
#define	INT_MSK_REG	(SREG_BASE + 0x074)  /* Interrupt Mask Register    */
#define ELB_CLKWAIT_REG (SREG_BASE + 0x0FC)	/* ELB Clock/Wait Register */

/*****************************************************************************/
/* System reset register definetion											 */
/* System Reset Status register												 */
/*																			 */
/*  31-------10 9  8  7  6  5  4  3  2  1  0								 */
/*Reserved      |  |  |  |  |  |  |  |  |  |								 */
/*	           |  |  |  |  |  |  |  |  |  ----> Global Reset				 */
/* 	          |  |  |  |  |  |  |  |  --> Mips Processor SLM And SDRAM		 */
/* 	         |  |  |  |  |  |  |  --> Voice Engine DMA						 */
/* 	        |  |  |  |  |  |  --> Voice Engine Processor					 */
/* 	       |  |  |  |  |  --> Framer Engine DMA								 */
/* 	      |  |  |  |  ----> Framer Engine Processor							 */
/* 	     |  |  |  --------> Ethernet 0										 */
/* 	    |  |  ------------> Ethernet 1										 */
/*     |   ---------------> Security engine									 */
/* 	   -------------------> Peripheral Block								 */
/*****************************************************************************/
#define	GLOBAL_RST	0x1						/* Global Reset */
#define MIPS_RST	0x2						/* MIPS reset   */
#define VE_DMA_RST	0x4						/* Voice Engine DMA reset  */
#define VE_CPU_RST	0x8						/* Voice Processor Reset   */
#define FE_DMA_RST	0x10					/* Framer Engine DMA reset */
#define FE_CPU_RST	0x20					/* Framer Engine Processor */
#define MAC0_RST	0x40					/* Ethernet 0 Reset */
#define MAC1_RST	0x80					/* Ethernet 1 Reset */
#define SE_RST		0x100					/* Security Engine Reset */
#define PER_RST		0x200					/* Peripheral Block Reset */
#define MAC2_RST	0x400					/* Ethernet 2 Reset */
		
/************************************/
/* define VERSION ID of each Target */
/************************************/

#define CPU_DEVID_MASK			0xff00
#define CPU_DEVID_FAM_MASK		0xf000
#define CPU_MSP_5000			0x50
#define CPU_MSP_4000			0x40
#define CPU_MSP_3000			0x30
#define CPU_MSP_2000			0x20
#define CPU_MSP_2000S			0x2A
#define CPU_MSP_1000			0x10
#define CPU_MSP_FPGA_2000		0x02
#define CPU_MSP_5000_FAMILY		5000
#define	CPU_MSP_4000_FAMILY		4000
#define CPU_MSP_3000_FAMILY		3000
#define	CPU_MSP_2000_FAMILY		2000
#define CPU_MSP_1000_FAMILY		1000

#define MSP5_RESET_VAL  (MAC0_RST | MAC1_RST | VE_DMA_RST       \
                        | VE_CPU_RST | FE_DMA_RST | FE_CPU_RST  \
                        | SE_RST | PER_RST)

#define MSP4_RESET_VAL  (MAC0_RST | MAC1_RST | MAC2_RST | VE_DMA_RST    \
                        | VE_CPU_RST | FE_DMA_RST | FE_CPU_RST          \
                        | SE_RST | PER_RST)
#define	MSP1_RESET_VAL	(MAC0_RST | MAC2_RST | PER_RST)
#define MSP_CRESET_VAL  (PER_RST)


#define ELB_BASE	0xBC000080
#define	CS0_CNFG_REG	(ELB_BASE + 0x00)  /* ELB CS0 Configuration Reg    */
#define	CS0_BA_REG		(ELB_BASE + 0x04)  /* ELB CS0 Base Address Reg     */
#define	CS0_MSK_REG		(ELB_BASE + 0x08)  /* ELB CS0 Mask Register        */

#define	CS1_CNFG_REG	(ELB_BASE + 0x10)  /* ELB CS1 Configuration Reg    */
#define	CS1_BA_REG		(ELB_BASE + 0x14)  /* ELB CS1 Base Address Reg     */
#define	CS1_MSK_REG		(ELB_BASE + 0x18)  /* ELB CS1 Mask Register        */

#define	CS2_CNFG_REG	(ELB_BASE + 0x20)  /* ELB CS2 Configuration Reg    */
#define	CS2_BA_REG		(ELB_BASE + 0x24)  /* ELB CS2 Base Address Reg     */
#define	CS2_MSK_REG		(ELB_BASE + 0x28)  /* ELB CS2 Mask Register        */

#define	CS3_CNFG_REG	(ELB_BASE + 0x30)  /* ELB CS3 Configuration Reg    */
#define	CS3_BA_REG		(ELB_BASE + 0x34)  /* ELB CS3 Base Address Reg     */
#define	CS3_MSK_REG		(ELB_BASE + 0x38)  /* ELB CS3 Mask Register        */

#define	CS4_CNFG_REG	(ELB_BASE + 0x40)  /* ELB CS4 Configuration Reg    */
#define	CS4_BA_REG		(ELB_BASE + 0x44)  /* ELB CS4 Base Address Reg     */
#define	CS4_MSK_REG		(ELB_BASE + 0x48)  /* ELB CS4 Mask Register        */

#define	CS5_CNFG_REG	(ELB_BASE + 0x50)  /* ELB CS5 Configuration Reg    */
#define	CS5_BA_REG		(ELB_BASE + 0x54)  /* ELB CS5 Base Address Reg     */
#define	CS5_MSK_REG		(ELB_BASE + 0x58)  /* ELB CS5 Mask Register        */

#define	CS6_CNFG_REG	(ELB_BASE + 0x60)  /* ELB CS6 Configuration Reg    */
#define	CS6_BA_REG		(ELB_BASE + 0x64)  /* ELB CS6 Base Address Reg     */
#define	CS6_MSK_REG		(ELB_BASE + 0x68)  /* ELB CS6 Mask Register        */

#define	CS7_CNFG_REG	(ELB_BASE + 0x70)  /* ELB CS7 Configuration Reg    */
#define	CS7_BA_REG		(ELB_BASE + 0x74)  /* ELB CS7 Base Address Reg     */
#define	CS7_MSK_REG		(ELB_BASE + 0x78)  /* ELB CS7 Mask Register        */
		
#define		CS_SIZE_8MEG		0x0
#define 	CS_SIZE_4MEG		0x40
#define 	CS_SIZE_2MEG		0x60
#define 	CS_SIZE_1MEG		0x70
#define 	CS_SIZE_512K		0x78
#define 	CS_SIZE_256K		0x7c
#define 	CS_SIZE_128K		0x7e
#define		CS_SIZE_64K			0x7f

#define CS0_BASE_ADD_VAL	0x180			/* base 0x1f800000 */		
#define CS0_CNFG_REG_VAL	0x765			/* Time = Max, Size 8bits, Mode Intel */
#define CS0_ADD_SPACE		CS_SIZE_8MEG	/* Last 8 MegBytes */

#define CS1_BASE_ADD_VAL	0x0				/* base 0x1E000000 */		
#define CS1_CNFG_REG_VAL	0x765			/* Time = Max, Size 8bits, Mode Intel */
#define CS1_ADD_SPACE		CS_SIZE_4MEG	/* Address Space 4 MegBytes */

#define CS2_BASE_ADD_VAL	0x40			/* base 0x1E400000 */		
#define CS2_CNFG_REG_VAL	0x5				/* Size 8bits, Mode Intel */
#define CS2_ADD_SPACE		CS_SIZE_4MEG	/* Address Space 4 MegBytes */

#define CS3_BASE_ADD_VAL	0x80			/* base 0x1E800000 */		
#define CS3_CNFG_REG_VAL	0x5				/* Size 8bits, Mode Intel */
#define CS3_ADD_SPACE		CS_SIZE_4MEG	/* Address Space 4 MegBytes */

#define CS4_BASE_ADD_VAL	0xc0			/* base 0x1EC00000 */		
#define CS4_CNFG_REG_VAL	0x765			/* Time = Max, Size 8bits, Mode Intel */
#define CS4_ADD_SPACE		CS_SIZE_4MEG	/* Address Space 4 MegBytes */

#define CS5_BASE_ADD_VAL	0x100			/* base 0x1F000000 */		
#define CS5_CNFG_REG_VAL	0x5				/* Size 8bits, Mode Intel */
#define CS5_ADD_SPACE		CS_SIZE_4MEG	/* Address Space 4 MegBytes */

#define CS6_BASE_ADD_VAL	0x140			/* base 0x1F400000 */		
#define CS6_CNFG_REG_VAL	0x5				/* Size 8bits, Mode Intel */
#define CS6_ADD_SPACE		CS_SIZE_2MEG	/* Address Space 2 MegBytes */

#define CS7_BASE_ADD_VAL	0x160			/* base 0x1F600000 */		
#define CS7_CNFG_REG_VAL	0x5				/* Size 8bits, Mode Intel */
#define CS7_ADD_SPACE		CS_SIZE_2MEG	/* Address Space 2 MegBytes	*/

#define	PER_BASE			0xB8400000		
#define	GPIO_CFG2_REG		(PER_BASE + 0xE8)
#define GPIO_CFG3_REG		(PER_BASE + 0x170)	

#endif /* _BRECIS_H_ */

