/*************************************************************
 * File: util/argvize.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *  200205	Touch and put in bbload (rsewill)
 *	970304	Start of revision history
 */

#include <defines.h>

/** int argvize(av,maxargs, s) place address of each word in s into the array av */
int argvize(av,maxargs,s)
char *av[];
int  maxargs;
char *s;
{
char **pav = av, c;
int ac;

for (ac=0;ac<maxargs;ac++) {
	/* step over cntrls and spaces */
	while(*s && *s <= ' ') ++s;

	/* if eos quit */
	if(!*s) break;

	c = *s;
	/* if it's a quote skip forward */
	if(c == '\'' || c == '"') {
		if (pav) *pav++ = ++s;
		while(*s && *s != c) ++s;
		if(*s) *s++ = 0;
		}
	else { /* find end of word */
		if (pav) *pav++ = s;
		while(' ' < *s) ++s;
		}

	/* not eos inc ptr */
	if(*s) *s++ = 0;
	}

if (pav) *pav++ = NULL;			/* end argument list with null pointer */

return(ac);
}

