/******************************************************************
 * Copyright (c) 2001,2002,2003 BRECIS Communications
 *      This software is the property of BRECIS Communications
 *      and may not be copied or distributed in any form without
 *      a prior licensing arrangement.
 *
 * BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND
 * FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 *
 */
/*************************************************************
 * File: lib/a5000.s
 * Purpose: Part of C runtime library
 */

#include "mips.h"
#include "defines.h"
#include "brecis.h"

	.comm k1tmp,4


	############# LR5000 #################
	#
	.globl a5000init
	.ent a5000init
a5000init:

	/* clear software interrupts */
	mtc0	zero, C0_CAUSE

	/* Initialize Config register */
	mfc0	t0, C0_CCC

	li		t1, 0x0e000007		/* insure both kuseg and k0seg are cached */
	not		t1
	and		t0, t1
	or		t0, 0x06000003
	mtc0	t0, C0_CCC
		
	/*********************************************************************/
	/* Initialize Count and Compare registers							 */
	/*********************************************************************/
	mtc0    zero, C0_COUNT          /*Clear Count register */
	la      t0, -1

	mtc0    t0, C0_COMPARE          /* Set compare to -1   */

	mtc0    zero, C0_CAUSE


/**********************************************************/
/* Software reset MAC0, MAC1, Peripheral, PE DMA, PE CPU, */
/*                VE DMA, VE CPU						  */
/**********************************************************/ 
getDevId:
	move	t3, ra		/* preserve ra */
	bal		cpuType
	move	ra, t3		/* restore ra */

	/* cpuType returns the mapped cpu type in v0 and the DEV_ID_REG in v1 */  
	move	s2, v0		/* hold mapped cpu type in s2 */
		
	li		t2,MSP5_RESET_VAL	/* if MSP5000 reset */
	li		t3,MSP_CRESET_VAL
	move	t4, t2
	beq		v0,CPU_MSP_5000_FAMILY, romInitStartSystemReset
	li		t2,MSP4_RESET_VAL	/* if MSP4000 reset */
	li		t3,MSP_CRESET_VAL
	move	t4, t2
	beq		v0,CPU_MSP_4000_FAMILY, romInitStartSystemReset
	beq		v0,CPU_MSP_2000_FAMILY, romInitStartSystemReset
	li	t2, MSP1_RESET_VAL
	move	t4, t2
	beq	v0, CPU_MSP_1000_FAMILY, romInitStartSystemReset

	b		reset_done			/* all other chips we not know how to reset */

romInitStartSystemReset:
	li		t0,RST_SET_REG
	sw		t2,0(t0)
	li		t0,SYS_RST_REG				  
romInitCheckReset:
	lw		t1,0(t0)
	and		t1, t4
	bne		t1,t2,romInitCheckReset
	li		t0,RST_CLR_REG
	sw		t2,0(t0)
	li		t0,SYS_RST_REG
	li		t1,MSP_CRESET_VAL
romInitCheckClearReset:
	lw	t2,0(t0)
	and	t2,t2,t1
	bne	t2,zero,romInitCheckClearReset

reset_done:

/***********************************************************/
/* Program all the Clock Speed for all block               */
/***********************************************************/
	li		t1, CPU_DEVID_FAM_MASK
	and		t1,v1
	beqz	t1, 9f		/* if FPGA, do not initialize clock speeds */		

	la			t2, clock_settings
	bne		v0, CPU_MSP_1000_FAMILY, 0f	/* If not Zeus */
	la		t2, clock_settings_zeus
	b		7f

0:
	bne			v0, CPU_MSP_2000_FAMILY, 7f		/* not Polo */
	la			t2, clock_settings_polo
	move		t0, v1			/* determine Polo device */
	and			t0, CPU_DEVID_SUBFAMILY
	srl			t0, t0, 16		/* get subfamily */
	beq			t0, POLO_SUBFAMILY_2005, 3f		/* if Polo 2005 */
	bne			t0, POLO_SUBFAMILY_2007, 7f		/* if not Polo 2007 */
		
3:	la			t2, clock_settings_polo_20052007

7:
	lw			t0, 0(t2)		/* get clock address */
	lw			t1, 4(t2)		/* get value to store */
	add			t2, 8	
	beqz		t0, 9f			/* if no more clocks to set */
	sw			t1, 0(t0)		/* set clock register */
	b			7b				/* loop for next clock */
	
9:	

#define UART_BASE	0xBC000100	/* Base address to UART            */
#define NSREG(x) ((x)*4)
#define DATA (NSREG(0))	/* data register (R/W)             */
#define IER  (NSREG(1))	/* interrupt enable (W)            */
#define IIR  (NSREG(2))	/* interrupt identification (R)    */
#define	FIFO (NSREG(2))	/* 16550 fifo control (W)          */
#define CFCR (NSREG(3))	/* line control register (R/W)     */
#define MCR  (NSREG(4))	/* modem control register (R/W)    */
#define LSR  (NSREG(5))	/* line status register (R/W)      */
#define MSR  (NSREG(6))	/* modem status register (R/W)     */
#define SCR  (NSREG(7))	/* scratch register (R/W)          */
#define FIFO_ENABLE     0x01    /* enable fifo */
#define FIFO_RCV_RST    0x02    /* reset receive fifo */
#define FIFO_XMT_RST    0x04    /* reset transmit fifo */
#define FIFO_DMA_MODE   0x08    /* enable dma mode */
#define FIFO_TRIGGER_1  0x00    /* trigger at 1 char */
#define FIFO_TRIGGER_4  0x40    /* trigger at 4 chars */
#define FIFO_TRIGGER_8  0x80    /* trigger at 8 chars */
#define FIFO_TRIGGER_14 0xc0    /* trigger at 14 chars */

/*--------------------------------------------------------------------------+
| character format control register
+--------------------------------------------------------------------------*/
#define CFCR_DLAB       0x80    /* divisor latch */
#define CFCR_SBREAK     0x40    /* send break */
#define CFCR_PZERO      0x30    /* zero parity */
#define CFCR_PONE       0x20    /* one parity */
#define CFCR_PEVEN      0x10    /* even parity */
#define CFCR_PODD       0x00    /* odd parity */
#define CFCR_PENAB      0x08    /* parity enable */
#define CFCR_STOPB      0x04    /* 2 stop bits */
#define CFCR_8BITS      0x03    /* 8 data bits */
#define CFCR_7BITS      0x02    /* 7 data bits */
#define CFCR_6BITS      0x01    /* 6 data bits */
#define CFCR_5BITS      0x00    /* 5 data bits */

/*--------------------------------------------------------------------------+
| modem control register
+--------------------------------------------------------------------------*/
#define MCR_LOOPBACK    0x10    /* loopback */
#define MCR_IENABLE     0x08    /* output 2 = int enable */
#define MCR_DRS         0x04    /* output 1 = xxx */
#define MCR_RTS         0x02    /* enable RTS */
#define MCR_DTR         0x01    /* enable DTR */

#define LSR_TXRDY       0x20    /* transmitter ready */

#define NS16550_XTAL_FREQ       (SLM_CLOCK_RATE / 2)
#define UART_FREQ	NS16550_XTAL_FREQ
#define	ZEUS_UART_FREQ	29491200	/* Zeus UART clock */
#define	ZEUS_UART_CLK_GEN	316659349	/* Zeus UART clock gen value */
#define UART_FPGA_FREQ		6000000
#define BAUD_RATE	57600
#if (DEFBAUD != B57600)
#error "BAUD_RATE must be actual speed, DEFBAUD is index into table for speed"
#endif

UART_INITIALIZE:

	/* If MSP 1000 type, treat as 2000 type here */
	beq		v0, CPU_MSP_1000_FAMILY, 0f
	/* If MSP 2000 type, initialize gpio pins for output */
	bne		v0, CPU_MSP_2000_FAMILY, 1f		/* not MSP 2000 type */
0:
	li		t0, RST_CLR_REG
	li		t1, 1<<9
	sw		t1, 0(t0)
	li		t0, GPIO_CFG3_REG
	lw		t1, 0(t0)
	li		t2, 0xff0000ff
	and		t1, t2
	li		t2, 0x00199100
	or		t1, t2
	sw		t1, 0(t0)											
		
	/* Also initialize SDRAM Read Data Clock Select if MSP2000 */
	li		t0, ELB_CLKWAIT_REG
	lw		t1, 0(t0)
	li		t2, 1<<31
	or		t1, t2
	sw		t1, 0(t0)			
					
1:	
	/****************************************************************/
	/* Initialize UART                                              */
	/* Baud UART Clock 50MHz, Baud rate			   			        */
	/****************************************************************/
	/* uart init - Baud Rate										*/
	/****************************************************************/
	li      t2,(UART_FREQ+8*BAUD_RATE)/(16*BAUD_RATE) /* brtc = CLK/16/speed */
	li	k1, UART_FREQ
	bne	v0, CPU_MSP_1000_FAMILY, 0f	/* If not Zeus */
	li	t2, (ZEUS_UART_FREQ+8*BAUD_RATE)/(16*BAUD_RATE)	/* brtc = CLK/16/speed */
	li	k1, ZEUS_UART_FREQ

0:
	li		t1, CPU_DEVID_FAM_MASK	
	and		t1, v1
	bnez	t1, 1f				/* not fpga */
	li      t2,(UART_FPGA_FREQ+8*BAUD_RATE)/(16*BAUD_RATE)
	li	k1, UART_FPGA_FREQ
1:				
	li      t1,UART_BASE
	li      t0,FIFO_ENABLE|FIFO_RCV_RST|FIFO_XMT_RST|FIFO_TRIGGER_4
	sw      t0,FIFO(t1)
	li      t0,CFCR_DLAB                    /* select brtc divisor */
	sw      t0,CFCR(t1)
	sw      t2,DATA(t1)                     /* store divisor lsb */
	srl     t2,8    
	sw      t2,IER(t1)                      /* store divisor msb */
	li      t0,CFCR_8BITS                   /* set 8N1 mode */
	sw      t0,CFCR(t1)
#if 0
	li      t0,MCR_DTR|MCR_RTS              /* |MCR_IENABLE enable DTR & RTS */
	sw      t0,MCR(t1)
#endif
	li      t0,0
	sw      t0,MCR(t1)
	li      t0,0                            /* enable receive interrupt(!) */
	sw      t0,IER(t1)

	/* CAUTION: we destroy s7 as does our caller because we can't use ram */

	move	s7, ra				/* save ra w/o using ram */	
	la		a0, crlfstr
	bal		a5000StrOut
	move	a0, v1				/* print out the device id */
	bal		a5000PrintWordReg
	la		a0, crlfstr
	bal		a5000StrOut

	/* s0 is index * 4 for testing different memory configurations */
	
	li		s0, 0		/* initially size for largest memory */

ramdetect:		
	li      t0,MEM_RFT_REG
	li		t1, CPU_DEVID_FAM_MASK
	and		t1, v1
	bnez	t1, 1f				/* if not FPGA */
	li		t1, 0x9c400			/* hardcode memory refresh for FPGA */	
	b		2f
1:
	la		t1, mem_rft
	addu	t1, s0
	lw		t1, 0(t1)
2:
	sw      t1,0(t0)

	la		t1, mem_rfc
	addu	t1, s0
	lw		t1, 0(t1)				
	li      t0,MEM_RFC_REG
	sw      t1,0(t0)
		
	/* Set internal timing parameters */
	/* the default is already 0x6a121 */
	la		t1, mem_tmgm
	addu	t1, s0
	lw		t1, 0(t1)				
	li      t0,MEM_TMGM_REG
	sw      t1,0(t0)

	/* A write to this register kicks the SDRAM controller initialization */
	li      t2,1
	la		t1, mem_cnfg
	addu	t1, s0
	lw		t1, 0(t1)	
	li  	t0, MEM_CNFG_REG		/* setup Dram Address */
	sw      t1, 0(t0)

	/* Wait for the initialization to complete */
waitForInitCntl:
	li      t0,MEM_INIT_REG
	lw      t1,0(t0)
	bne     t1,t2,waitForInitCntl

	la		t1, mem_size
	addu	t1, s0
	lw		t1, 0(t1)
	beqz	t1, 4f				/* if default memory configuration */
			
	li		a0, SDRAMADDRESS 
	move	s1, v1				/* preserve v1 - deviceid */				   
	jal		sizemem				/* try to size memory */
	move	v1, s1				/* restore v1 - deviceid */

	la		t1, mem_size
	addu	t1, s0
	lw		t1, 0(t1)				
	bgeu	v0, t1, 5f			/* if greater than or equal memory size */
	addiu	s0, 4				/* re-size for next smaller size */
	b		ramdetect	

4:	/* We still need to sizemem for the default memory configuration */
	/* because we return that value in v0 */

	li		a0, SDRAMADDRESS
	move	s1, v1				/* preserve v1 - deviceid */				   
	jal		sizemem		
	move	v1, s1				/* restore v1 - deviceid */
   li		s0, -1				/* flag using default memory table entry */

5:
	/* ram test takes long time, only uncommment when possible ram problem */
#if 0
	move	t6, v0				/* size of ram in bytes */
	li		t5, SDRAMADDRESS	/* starting ram address */

ramtest:
	li		t1, 0xffff			/* should we print the current address? */
	and		t1, t5
	bnez	t1, 1f				/* if do not print current address */

	la		a0, crstr			/* print return and overwrite previous text */
	bal		a5000StrOut	
	move	a0, t5				/* print current address */
	bal		a5000PrintWordReg	
1:
	lw		t9, 0(t5)			/* save original value of memory location */

	li		t7, 0				/* write zero test */
	sw		t7, 0(t5)
	lw		t8, 0(t5)	
	bne		t7, t8, ramtesterr	/* if error */

	li		t7, 0xffffffff		/* write ones test */
	sw		t7, 0(t5)
	lw		t8, 0(t5)	 
	bne		t7, t8, ramtesterr	/* if error */

	sw		t5, 0(t5)			/* write address test */
	lw		t8, 0(t5)	 
	beq		t5, t8, ramtestpass	/* if pass */
	move	t7, t5				/* set up expected value for ramtesterr */

ramtesterr:
	la		a0, crstr
	bal		a5000StrOut
	move	a0, t5
	bal		a5000PrintWordReg
	la		a0, ramstre1
	bal		a5000StrOut
	move	a0, t7
	bal		a5000PrintWordReg
	la		a0, ramstre2
	bal		a5000StrOut
	move	a0, t8
	bal		a5000PrintWordReg
	la		a0, crlfstr
	bal		a5000StrOut	

ramtestpass:
	sw		t9, 0(t5)			/* restore original value of memory location */
	li		t1, 4
	addu	t5, t1
	subu	t6, t1
	bgtz	t6, ramtest	
#endif

	/* print copyright message */
	la		a0, copyright
	bal		a5000StrOut

	la		a0, detectedram
	bgez	s0, 1f	/* if detected memory size */				   
	la		a0, defaultram
1:
	bal		a5000StrOut
	move	a0, v0
	bal		a5000PrintWordReg

	/* print version */
	la		a0, version
	bal		a5000StrOut

	    /* print RAM frequency */
#if DRAM_CLOCK_RATE == 100000000
    la      a0, RAM100
    bal     a5000StrOut
#endif
#if DRAM_CLOCK_RATE == 125000000
    la      a0, RAM125
    bal     a5000StrOut
#endif
#if DRAM_CLOCK_RATE == 150000000
    la      a0, RAM150
    bal     a5000StrOut
#endif

	move	ra, s7				/* restore ra */

	/*****************************************************************/
    /*	Program External Local Bus CS  								 */
	/*****************************************************************/
 	la			t2, cs_settings
	bne			s2, CPU_MSP_2000_FAMILY, 1f		/* not Polo */
	la			t2, cs_settings_polo	

1:	lw			t0, 0(t2)		/* get next chip select base address */
	beqz		t0, 5f			/* if no more chip selects to set */
	lw			t1, 8(t2)		/* set CSx_BA_REG value */
	sw			t1, 4(t0)
	lw			t1, 4(t2)		/* set CSx_CNFG_REG value */
	sw			t1, 0(t0)
	lw			t1, 12(t2)		/* set CSx_MSK_REG value */
	sw			t1, 8(t0)
	add			t2, 16
	b			1b

5:		
	/**********************************************************/
	/*	int0 - NU											 */	
	/*	int1- Dallas Ds21352 T1 framer/liu					 */
	/*	int2 - NU											 */
	/*	int3- MAC PHY 1										 */
	/*	int4- WAN chip -ADSL								 */
	/*	int5- MACPHY 2										 */
	/*	int6 - NU											 */
	/*	int7 - NU											 */
	/*********************************************************/

	li		t0, INT_MSK_REG			/* clear all interrupts */		
	li		t1, 0
	sw		t1, 0(t0)	

	# select the correct cache flushing routines
	la	s0,r5000_flush

	j	ra
	.end a5000init

/*************************************************************
*  cpuType:		
*  Return the mapped (5000, 4000, 2000, ...) cpu type in v0.
*  Return DEV_ID_REG in v1.
*  This routine MUST preserve register t3 across calls
*   because getDevId above assumes this register is preserved.
*/
	.globl	cpuType
	.ent	cpuType
cpuType:
	li		t0,DEV_ID_REG	/* read DEVID register	*/
	lw		v1,0(t0)

	li		t1,CPU_DEVID_MASK
	and		t0,v1,t1		/* only want the ID bits*/
	srl		t0,t0,8			/* shift right 8 bits	*/
	move	v0, t0			/* compute family */
	srl		v0,v0,4			/* top 4 bits are family bits */
	li		t2, 1000		/* multiply by 1000 decimal to get family */
	mul		v0, v0, t2
	la		t1, romcpu_id_map

	/* we now have family in v0, DEV_ID_REG in v1 */

cpuTypeHunt:
	lw		t2, 0(t1)
	beqz	t2, 9f		/* end of table, use default mapping */
	beq		t2, 1, 1f
0:
	addiu	t1, 16		/* advance to next quadruple */
	b		cpuTypeHunt

1:	/* compare low 16 bits of DEV_ID_REG to find correct FPGA type */
	move	t0, v1
	and		t0, 0xffff
	lw		t2, 4(t1)
	bgt		t0, t2, 0b	/* not this FPGA */
	lw		t2, 8(t1)
	blt		t0, t2, 0b	/* not this FPGA */
	lw		v0, 12(t1)	/* get family */
9:
	j		ra
	.end	cpuType
			
	.globl	deviceID
	.ent	deviceID
deviceID:
	li		t0, DEV_ID_REG
	lw		v0, 0(t0)
	j		ra				
	.end	deviceID
		
/*************************************************************
*  cpuclockrate:		
*  Return cpu clk frequency based on chip type.
*/
	.globl	cpuclockrate
	.ent	cpuclockrate
cpuclockrate:
	move	t3, ra				/* preserve ra */
	bal		cpuType
	move	ra, t3				/* restore ra */
	li		t0, CPU_CLOCK_RATE		
	beq		v0, 1000, 0f		/* If Zeus */
	bne		v0, 2000, 1f		/* not Polo */
0:
	li		t0, CPU_CLOCK_RATE_POLO
1:
	move	v0, t0		
	j		ra
	.end	cpuclockrate
		
#if 0 /* not yet */
/*************************************************************
*  a5000clkfunc:		
*  clkfunc args
*	1,v = set secs to v
*	2 = get secs
*	3 = get usecs
*/
	.globl	a5000clkfunc
	.ent	a5000clkfunc
a5000clkfunc:
	beq		a0, 1, 1f
	beq		a0, 2, 2f
	beq		a0, 3, 3f
	b		9f
		
1:	/* set secs to a1 */
	sw		a1, a5000clk_seconds
	b		9f

2:	/* get time in seconds */
	lw		v0, a5000clk_seconds
	b		9f

3:	/* get time in micro-seconds */
	move	t4, ra		/* preserve ra */
	bal		cpuclockrate
	move	ra, t4		/* restore ra */
	li		v1, 1000000		
	div		v0, v1
	mflo	v1
	lw		t1, a5000clk_seconds
	mfc0	t2, C0_COMPARE
	mfc0	t3, C0_COUNT
	li		t4, 1000000					/* microseconds per second */
	mult	t1, t4
	mflo	t1							/* microseconds for seconds */
	subu	t2, t2, v0					/* start time previous interval */
	subu	t3, t3,t2					/* 1/2 cpu pipeline since last int */
	li		t4, v1
	div		t3, t4
	mflo	t3
	addu	v0, t1, t3
9:		
	j		ra
	.end	a5000clkfunc
			
/*************************************************************
*  a5000clkinit:		
*	Called from _exception in mips.s. 
*	Return address is saved in k1.
*/
	.globl	a5000clkinit
	.ent	a5000clkinit
a5000clkinit:
	la		v0, a5000clkfunc
	j		ra
	.end	a5000clkinit
#endif
/*************************************************************
*  a5000exception:
*	Called from _exception in mips.s. 
*	Return address is saved in k1.
*/
	.globl	a5000exception
	.ent	a5000exception
a5000exception:
	la	k0,k1tmp
	lw	k1,(k0)
	j	k1
	.end a5000exception

	.globl a5000colon
	.ent a5000colon
a5000colon:
	la	a0, colonstr
	j	a5000StrOut
	.end a5000colon
	
	.globl a5000Wave
	.ent a5000Wave
a5000Wave:
	la	a0, wavestr
	j	a5000DebugPrint
	.end a5000Wave
		
	.globl a5000DebugPrint
	.ent a5000DebugPrint
a5000DebugPrint:
	move t9, ra
	move t8, a0
	la	a0, crlfstr
	bal a5000StrOut

	move a0, t8
	bal a5000PrintWordReg

	la	a0, colonstr
	bal a5000StrOut

	move a0, t8
	bal a5000StrOut

	move ra, t9
	j	ra
	.end a5000DebugPrint
		
/**********************************************/
/*  Output String out to console	      */
/**********************************************/
	.globl a5000StrOut
	.ent a5000StrOut

	/* CAUTION: callers assume routine won't destroy t5-t9 */

a5000StrOut:
	.set noat
	li	AT,UART_BASE
10:
	lbu	t3,0(a0)	/* read first char location */
	beqz t3,20f

	lw	t4,LSR(AT)	/* Read LSR see character ready */
	and	t4,LSR_TXRDY
	beqz  t4,10b

	sw	t3,DATA(AT)
	addu a0,a0,1
	b	10b
20:
	j	ra
	.end a5000StrOut
		
	.globl a5000PrintWordReg
	.ent a5000PrintWordReg

	/* CAUTION: callers assume routine won't destroy t5-t9 */

a5000PrintWordReg:
	 move 	t3,a0 
	 li	t2,8		/* do 8 nibbles */

pWord:
	srl	a0,t3,28	/* Get the top nibble 	*/
	and	a0,0x0000000f	/* clear all but nibble */
	add	a0,'0'		/* Convert it to ascii 	*/
	sub	t4,a0,'9'
	blez	t4,2f	/* Print it if between 0 & 9 */

	add	a0,0x27
2:			/* Else add a little more for a to f */
	.set 	noat
	li	AT,UART_BASE
waitrdy_printw:
	lw	t4,LSR(AT) 
	and	t4,LSR_TXRDY
	beqz	t4,waitrdy_printw

	sw	a0,DATA(AT)	 
	sll	t3,t3,4	   /* Get the next digit */
	sub	t2,1	   /* Bump the nibble count */
	bgtz	t2,pWord	

	j	ra
	.end a5000PrintWordReg

colonstr:	.asciiz	":"
#if 0
crstr:		.asciiz	"\r"
ramstre1:	.asciiz	", expected "
ramstre2:	.asciiz	", got "		
#endif
copyright:	.asciiz	"\n\rCopyright (c) 2001,2002,2003 BRECIS Communications Corporation"
detectedram:.asciiz	"\n\rDetected SDRAM size: 0x"
defaultram:	.asciiz	"\n\rFailed to detect SDRAM size, using default: 0x"
version:	.asciiz "\n\rbbload version 1.2"
crlfstr:	.asciiz	"\n\r"
wavestr:	.asciiz	"Called wave\n\r"
#if DRAM_CLOCK_RATE == 100000000
RAM100:     .asciiz "\n\rSDRAM 100MHz\n\r"
#endif
#if DRAM_CLOCK_RATE == 125000000
RAM125:     .asciiz "\n\rSDRAM 125MHz\n\r"
#endif
#if DRAM_CLOCK_RATE == 150000000
RAM150:     .asciiz "\n\rSDRAM 150MHz\n\r"
#endif


/* memory configuration values:	
		mem_size is memory size we are testing
		mem_rft  is memory refresh timer (normally always 64 Millesecond)
		mem_rfc  is memory refresh counter
		mem_tmgm is	timing param value (normally always 0x6a121)
		mem_cnfg is memory configuration value

		A memory size of zero defines the default configuration if we
		cannot determine the correct memory configuration.

		Memory type/config		rfc				cnfg		
		256 Mbit (16Mb x 16)	0x2000			0x519d
		128 Mbit (8Mb x 16)		0x1000			0x319d
		64 Mbit (2Mbit x 32)	0x1000			0x111f
*/		
			.align	2
mem_size:	.word	0x4000000,	0x2000000,	0x1000000,	0x800000,	0
mem_rft:	.word	0x61a800,	0x61a800,	0x61a800,	0x61a800,	0x61a800
mem_rfc:	.word	0x2000,		0x1000,		0x1000,		0x1000,		0x1000	
mem_tmgm:	.word	0x6a121,	0x6a121,	0x6a121,	0x6a121,	0x6a121
mem_cnfg:	.word	0x519d,		0x319d,		0x11bd,		0x119f,		0x119f	

/* cpu_id_map is a special flag processing, mapped ID quadruple */
/* If no special processing, no entry in cpu_id_map */
/* one must still do special things for chips that emulate other chips */

romcpu_id_map:	.word	1,	0x90,	0x80,	5000	/* 5000 FPGA */ 
				.word	1,	0xbf,	0xb0,	2000	/* 2000 FPGA */
				.word	1,	0xaf,	0xa0,	4000	/* 4000 FPGA */		
		.word	1,	0x7f,	0x00,	1000	/* 1000 FPGA */
				.word	0,	0,		0,		0		/* end of table */

/* clock_settings tables are used for setting the hardware clock registers.
		
	These tables have the following format:
	register address, value
	...
	0, 0						end of list

	If we are not Polo, we use the clock_settings table.
	If we are Polo, we use the clock_settings_polo table or the
	clock_settings_polo_20052007 table.
	Only the registers in the table are changed;  
	registers not in the table are assumed to be correct 
	from the power-up or reset state.
*/

clock_settings:	.word	MIPS_CLK_REG, CPU_CLOCK_VAL	/* Mips Clock */
				.word	DVB_CLK_REG, DRAM_CLOCK_VAL	/* DRAM Clock */
				.word	SMAC_CLK_REG, SLM_CLOCK_VAL	/* SLM/SEC/ETH Clock */
				.word	FE_CLK_REG, PE_CLOCK_VAL	/* Packet Engine Clock */
				.word	VE_CLK_REG, VE_CLOCK_VAL	/* Voice Engine Clock */
				.word	PERF_CLK_REG, PER_CLOCK_VAL	/* Peripheral Clock */
				.word	0, 0						/* End of list */

clock_settings_polo:	
				.word	MIPS_CLK_REG, CPU_CLOCK_VAL_POLO	/* Mips Clock */
				.word	PLL0_DIV_REG, PLL0_DIV_VAL_POLO		/* PLL0 DIVIDER */
				.word	PLL1_DIV_REG, PLL1_DIV_VAL_POLO		/* PLL1 DIVIDER */
				.word	0, 0								/* End of list */

clock_settings_polo_20052007:
				.word	SEC_CLK_REG, SEC_CLOCK_VAL_POLO		/* SEC Clock */
				.word	MIPS_CLK_REG, CPU_CLOCK_VAL_POLO	/* Mips Clock */
				.word	PLL0_DIV_REG, PLL0_DIV_VAL_POLO		/* PLL0 DIVIDER */
				.word	PLL1_DIV_REG, PLL1_DIV_VAL_POLO		/* PLL1 DIVIDER */
				.word	0, 0								/* End of list */

clock_settings_zeus:
		.word	MIPS_CLK_REG, CPU_CLOCK_VAL_POLO	/* MIPS clock */
		.word	PLL0_DIV_REG, PLL0_DIV_VAL_POLO		/* PLL0 divider */
		.word	PLL1_DIV_REG, PLL1_DIV_VAL_POLO		/* PLL1 divider */
		.word	PCM0_CLK_REG, ZEUS_UART_CLK_GEN		/* UART clock gen */
		.word	0, 0		/* End of list */

/* cs_settings tables are used for setting the chip select registers.

These tables have the following format:
		
CSx_CNFG_REG address, CSx_CNFG_REG value, CSx_BA_REG value, CSx_MSK_REG value
...
0,		0,		0,		0								end of list

If we are not Polo, we use the cs_settings table.
If we are Polo, we use the cs_settings_polo table.
Only the registers in the table are changed;
registers not in the table are assumed to be correct
from the power-up or reset state.
*/

cs_settings:
#if 0		
/* We are booting from CS0.
 * It would make sense to only change CS0 registers to change the timing
 * or the size.
 * We must be careful not to change the base address.
 * We must be careful not to change the size in bits (8x or 16x) of the chip
 * or bad things will happen.
    /************************************************************************/
    /*	CS0 - ROM ICE or Flash if JP25 set to AB			 				*/
 	/*  base reg  	= 0x180		Base Addr 	= 0x1f800000	 				*/
	/*	Config Reg	= 765		Max Time, Intel, 8bits		 				*/
 	/*	Mask reg    = 0										 				*/
	/************************************************************************/
		.word	CS0_CNFG_REG, CS0_CNFG_REG_VAL, CS0_BASE_ADD_VAL, CS0_ADD_SPACE
#endif
	/************************************************************************/
	/*	CS1 - NU	 FPGA									 				*/
  	/*  Base reg     = 0x0	   base addr =  0x1e000000		 				*/
	/*  Config       = 765	   Max TIme, Intel, 8bits		 				*/
	/*  Mask reg     = 0x40	   Size 4MegBytes  				 				*/
	/************************************************************************/
		.word	CS1_CNFG_REG, CS1_CNFG_REG_VAL, CS1_BASE_ADD_VAL, CS1_ADD_SPACE
	/************************************************************************/
	/*	CS2 - Dallas Ds21352 T1 framer/liu	 FPGA			 				*/
  	/*  Base reg     = 0x40	   base addr =  0x1e400000		 				*/
	/*  Config       = 5	   Intel, 8bits					 				*/
	/*  Mask reg     = 0x40	   Size 4MegBytes  				 				*/
	/*  										 			 				*/
	/************************************************************************/
		.word	CS2_CNFG_REG, CS2_CNFG_REG_VAL, CS2_BASE_ADD_VAL, CS2_ADD_SPACE
	/************************************************************************/
	/*	cs3 - WAN chip -ADSL								 				*/
  	/*  Base reg     = 0x8	   base addr =  0x1e800000		 				*/
	/*  Config       = 5	   Intel, 8bits					 				*/
	/*  Mask reg     = 0x40	   Size 4MegBytes  						 		*/
	/*  										 			 				*/
	/************************************************************************/
		.word	CS3_CNFG_REG, CS3_CNFG_REG_VAL, CS3_BASE_ADD_VAL, CS3_ADD_SPACE
	/************************************************************************/
	/*	cs4 - Flash if JP25 is set to BC					 				*/
  	/*  Base reg     = 0xc	   base addr =  0x1ec00000		 				*/
	/*  Config       = 0x765   Intel, 8bits, Max Time		 				*/
	/*  Mask reg     = 0x40	   Size 4MegBytes  				 				*/
	/*  										 			 				*/
	/************************************************************************/
		.word	CS4_CNFG_REG, CS4_CNFG_REG_VAL, CS4_BASE_ADD_VAL, CS4_ADD_SPACE
	/************************************************************************/
	/*	cs5 - NU											 				*/
  	/*  Base reg     = 0xc	   base addr =  0x1f000000		 				*/
	/*  Config       = 0x5     Intel, 8bits					 				*/
	/*  Mask reg     = 0x40	   Size 4MegBytes  				 				*/
	/*  										 			 				*/
	/************************************************************************/
		.word	CS5_CNFG_REG, CS5_CNFG_REG_VAL, CS5_BASE_ADD_VAL, CS5_ADD_SPACE
	/************************************************************************/
	/*	cs6 - NU											 				*/ 
 	/*  Base reg     = 0x14	   base addr =  0x1f400000		 				*/
	/*  Config       = 0x5     Intel, 8bits					 				*/
	/*  Mask reg     = 0x60	   Size 2MegBytes  				 				*/
	/*  										 			 				*/
	/************************************************************************/
		.word	CS6_CNFG_REG, CS6_CNFG_REG_VAL, CS6_BASE_ADD_VAL, CS6_ADD_SPACE
	/************************************************************************/
	/*	cs7 - NU											 				*/
 	/*  Base reg     = 0x14	   base addr =  0x1f600000		 				*/
	/*  Config       = 0x5     Intel, 8bits					 				*/
	/*  Mask reg     = 0x60	   Size 2MegBytes  				 				*/
	/*  										 			 				*/
	/************************************************************************/
		.word	CS7_CNFG_REG, CS7_CNFG_REG_VAL, CS7_BASE_ADD_VAL, CS7_ADD_SPACE
		.word	0, 0, 0, 0									/* end of list */
		
cs_settings_polo:
#if 0		
/* We are booting from CS0.
 * It would make sense to only change CS0 registers to change the timing
 * or the size.
 * We must be careful not to change the base address.
 * We must be careful not to change the size in bits (8x or 16x) of the chip
 * or bad things will happen.
    /************************************************************************/
    /*	CS0 - ROM ICE or Flash if JP25 set to AB			 				*/
 	/*  base reg  	= 0x180		Base Addr 	= 0x1f800000	 				*/
	/*	Config Reg	= 765		Max Time, Intel, 8bits		 				*/
 	/*	Mask reg    = 0										 				*/
	/************************************************************************/
		.word	CS0_CNFG_REG, CS0_CNFG_REG_VAL, CS0_BASE_ADD_VAL, CS0_ADD_SPACE
#endif
	/************************************************************************/
	/*	CS1 - NU	 FPGA									 				*/
  	/*  Base reg     = 0x0	   base addr =  0x1e000000		 				*/
	/*  Config       = 765	   Max TIme, Intel, 8bits		 				*/
	/*  Mask reg     = 0x40	   Size 4MegBytes  				 				*/
	/************************************************************************/
		.word	CS1_CNFG_REG, CS1_CNFG_REG_VAL, CS1_BASE_ADD_VAL, CS1_ADD_SPACE
	/************************************************************************/
	/*	CS2 - Dallas Ds21352 T1 framer/liu	 FPGA			 				*/
  	/*  Base reg     = 0x40	   base addr =  0x1e400000		 				*/
	/*  Config       = 5	   Intel, 8bits					 				*/
	/*  Mask reg     = 0x40	   Size 4MegBytes  				 				*/
	/*  										 			 				*/
	/************************************************************************/
		.word	CS2_CNFG_REG, CS2_CNFG_REG_VAL, CS2_BASE_ADD_VAL, CS2_ADD_SPACE
	/************************************************************************/
	/*	cs3 - WAN chip -ADSL								 				*/
  	/*  Base reg     = 0x8	   base addr =  0x1e800000		 				*/
	/*  Config       = 5	   Intel, 8bits					 				*/
	/*  Mask reg     = 0x40	   Size 4MegBytes  						 		*/
	/*  										 			 				*/
	/************************************************************************/
		.word	CS3_CNFG_REG, CS3_CNFG_REG_VAL, CS3_BASE_ADD_VAL, CS3_ADD_SPACE
	/************************************************************************/
	/*	cs4 - Flash if JP25 is set to BC					 				*/
  	/*  Base reg     = 0xc	   base addr =  0x1ec00000		 				*/
	/*  Config       = 0x765   Intel, 8bits, Max Time		 				*/
	/*  Mask reg     = 0x40	   Size 4MegBytes  				 				*/
	/*  										 			 				*/
	/************************************************************************/
		.word	CS4_CNFG_REG, CS4_CNFG_REG_VAL, CS4_BASE_ADD_VAL, CS4_ADD_SPACE
	/************************************************************************/
	/*	cs5 - NU											 				*/
  	/*  Base reg     = 0xc	   base addr =  0x1f000000		 				*/
	/*  Config       = 0x5     Intel, 8bits					 				*/
	/*  Mask reg     = 0x40	   Size 4MegBytes  				 				*/
	/*  										 			 				*/
	/************************************************************************/
		.word	CS5_CNFG_REG, CS5_CNFG_REG_VAL, CS5_BASE_ADD_VAL, CS5_ADD_SPACE
	/************************************************************************/
	/*	cs6 - NU											 				*/ 
 	/*  Base reg     = 0x14	   base addr =  0x1f400000		 				*/
	/*  Config       = 0x5     Intel, 8bits					 				*/
	/*  Mask reg     = 0x60	   Size 2MegBytes  				 				*/
	/*  										 			 				*/
	/************************************************************************/
		.word	CS6_CNFG_REG, CS6_CNFG_REG_VAL, CS6_BASE_ADD_VAL, CS6_ADD_SPACE
	/************************************************************************/
	/*	cs7 - NU											 				*/
 	/*  Base reg     = 0x14	   base addr =  0x1f600000		 				*/
	/*  Config       = 0x5     Intel, 8bits					 				*/
	/*  Mask reg     = 0x60	   Size 2MegBytes  				 				*/
	/*  										 			 				*/
	/************************************************************************/
		.word	CS7_CNFG_REG, CS7_CNFG_REG_VAL, CS7_BASE_ADD_VAL, CS7_ADD_SPACE
		.word	0, 0, 0, 0									/* end of list */
		
