#ifndef _ATN_TEST_H___
#define _ATN_TEST_H___

/* drv specific */
#define LNX_CMD_RBS             1
#define LNX_CMD_RBC             2
#define LNX_CMD_TBC             3
#define LNX_CMD_DRV_TPD         4
#define LNX_CMD_DRV_RFD         5
#define LNX_CMD_DRV_RRD         6
#define LNX_CMD_SRAM_TPD        7
#define LNX_CMD_SRAM_RFD        8
#define LNX_CMD_SRAM_RRD        9
#define LNX_CMD_SRAM_TRD        10
#define LNX_CMD_SRAM_RXF        11
#define LNX_CMD_SRAM_TXF        12
#define LNX_CMD_DRV_CMB         13
#define LNX_CMD_NIC_CMB         14
#define LNX_CMD_DUMP_REGS       15
#define LNX_CMD_WRITE_REG       16
#define LNX_CMD_READ_CFG_REG    17
#define LNX_CMD_WRITE_CFG_REG   18
#define LNX_CMD_DUMP_DREGS      19
#define LNX_CMD_DRV_SMB         20
//////////////////////////////////// added at 05-06-25
#define LNX_CMD_READ_BYTE           21
#define LNX_CMD_READ_PHY            22
#define LNX_CMD_WRITE_BYTE          23
#define LNX_CMD_WRITE_PHY           24
//////////////////////////////////// 


typedef struct at_rbs {
    u16     cmd;
    u16     size;
}at_rbs, at_rbc, at_tbc;

typedef struct at_drv_tpd {
    u16     cmd;
    u16     idx_start;
    u16     length;
    u8      data[0];
}at_drv_tpd, at_sram_tpd, at_drv_rfd, at_sram_rfd, 
 at_drv_rrd, at_sram_rrd, at_sram_trd;

typedef struct at_sram_rxf {
    u16     cmd;
    u16     length;
    u8      data[0];
}at_sram_rxf, at_sram_txf;

typedef struct at_drv_cmb {
    u16     cmd;
    u32     data[4];
}at_drv_cmb, at_sram_cmb;

typedef struct at_drv_smb {
    u16     cmd;
    u16     length;
    u8      data[0];
} at_drv_smb;      

typedef struct at_dump_regs {
    u16     cmd;
    u16     start;
    u16     length;
    u8      data[0];
}at_dump_regs, at_dump_dregs;

typedef struct at_write_reg {
    u16     cmd;
    u16     reg;
    u32     data;
    u32     mask;
}at_write_reg, at_write_cfg_reg;

typedef struct at_read_cfg_reg {
    u16     cmd;
    u16     reg;
    u32     data;
}at_read_cfg_reg;

//////////////////////////////////// added at 05-06-25
typedef struct at_write_breg {
    u16     cmd;
    u16     reg;
    u8      data;
}at_write_breg;

typedef struct at_read_breg {
    u16     cmd;
    u16     reg;
    u8      data;
}at_read_breg;

typedef struct at_write_preg {
    u16     cmd;
    u8      reg;
    u16     data;
}at_write_preg;

typedef struct at_read_preg {
    u16     cmd;
    u8      reg;
    u16     data;
}at_read_preg;
////////////////////////////////////

#endif
