#include "at.h"
#ifdef SIOCDEVPRIVATE
#include "drv_ioctl.h"
#include <asm/uaccess.h>

static int
at_priv_dump_regs(struct at_adapter* adapter, at_dump_regs* regs, void* usraddr)
{
    at_dump_regs* new_regs;
    uint32_t i;
    
    
    new_regs = kmalloc(sizeof(*regs)+regs->length*4, GFP_KERNEL);
    if (!new_regs) {
        return -ENOMEM;
    }
    new_regs->length = regs->length;
    new_regs->start = regs->start;
    new_regs->cmd = LNX_CMD_DUMP_REGS;
    
    for (i =0; i < regs->length; i++) {
        ((uint32_t*)new_regs->data)[i] = 
            AT_READ_REG(&adapter->hw, (4*i+regs->start));
    }
    
    if (copy_to_user(usraddr, new_regs, sizeof(*new_regs)+regs->length*4)) {
        kfree(new_regs);
        return -EFAULT;
    }
    kfree(new_regs);
    return 0;
}

static int
at_priv_dump_dregs(struct at_adapter* adapter, at_dump_dregs* regs, void* usraddr)
{
    at_dump_dregs* new_regs;
    uint32_t i;
    
    
    new_regs = kmalloc(sizeof(*regs)+regs->length*4, GFP_KERNEL);
    if (!new_regs) {
        return -ENOMEM;
    }
    new_regs->length = regs->length;
    new_regs->start = regs->start;
    new_regs->cmd = LNX_CMD_DUMP_DREGS;
    
    for (i =0; i < regs->length; i++) {
        AT_WRITE_REG(&adapter->hw, 0x1900, i+regs->start);
        ((uint32_t*)new_regs->data)[i] = 
            AT_READ_REG(&adapter->hw, 0x1904);
    }
    
    if (copy_to_user(usraddr, new_regs, sizeof(*new_regs)+regs->length*4)) {
        kfree(new_regs);
        return -EFAULT;
    }
    kfree(new_regs);
    return 0;
}

int 
at_priv_ioctl(struct net_device* netdev, struct ifreq * ifr)
{
    struct  at_adapter *adapter = netdev->priv;
    void *      addr = ifr->ifr_data;
    uint16_t    cmd;
    
    if(get_user(cmd, (uint16_t *) addr))
    return -EFAULT;
    
    switch (cmd) {
    case LNX_CMD_DUMP_REGS:
    {
    at_dump_regs regs;
    if(copy_from_user(&regs, addr, sizeof(regs)))
        return -EFAULT;
    return at_priv_dump_regs(adapter, &regs, addr);
    }
    case LNX_CMD_WRITE_REG:
    {
        at_write_reg wreg;
        uint32_t    data;
        if (copy_from_user(&wreg, addr, sizeof(wreg))) {
            return -EFAULT;
        }
        if (0xffffffff != wreg.mask) {
            data = AT_READ_REG(&adapter->hw, wreg.reg);
            data = (wreg.data&wreg.mask) | (data&~wreg.mask);
        } else {
            data = wreg.data;
        }
        AT_WRITE_REG(&adapter->hw, wreg.reg, data);
        return 0;
    }
    //////////////////////////////////// added at 05-06-25
    case LNX_CMD_READ_BYTE:
    {
        at_read_breg breg;
        if(copy_from_user(&breg, addr, sizeof(breg)))
            return -EFAULT;
        breg.data = AT_READ_REGB(&adapter->hw, breg.reg);
        if (copy_to_user(addr, &breg, sizeof(breg)))
            return -EFAULT;
        return 0;       
    }
    case LNX_CMD_WRITE_BYTE:
    {
        at_write_breg wbreg;
        
        if (copy_from_user(&wbreg, addr, sizeof(wbreg))) {
            return -EFAULT;
        }
        AT_WRITE_REGB(&adapter->hw, wbreg.reg, wbreg.data);
        return 0;
    }
    case LNX_CMD_READ_PHY:
    {
        at_read_preg preg;
        unsigned long flags;
        
        if(copy_from_user(&preg, addr, sizeof(preg)))
            return -EFAULT;
        
        spin_lock_irqsave(&adapter->stats_lock, flags); 
        if (at_read_phy_reg(&adapter->hw,
                            preg.reg,
                            &preg.data)) {
            spin_unlock_irqrestore(&adapter->stats_lock, flags);                                
            return -EFAULT;
        }
        spin_unlock_irqrestore(&adapter->stats_lock, flags);
        
        if (copy_to_user(addr, &preg, sizeof(preg)))
            return -EFAULT;
        return 0;       
    }
    case LNX_CMD_WRITE_PHY:
    {
        at_write_preg preg;
        unsigned long flags;
        
        if (copy_from_user(&preg, addr, sizeof(preg))) {
            return -EFAULT;
        }
        
        spin_lock_irqsave(&adapter->stats_lock, flags);
        if (at_write_phy_reg(&adapter->hw,
                             preg.reg,
                             preg.data)) {
            spin_unlock_irqrestore(&adapter->stats_lock, flags);                                
            return -EFAULT;
        }
        spin_unlock_irqrestore(&adapter->stats_lock, flags);
        return 0;
    }   
    ///////////////////////////////////

    case LNX_CMD_DUMP_DREGS:
    {
        at_dump_dregs regs;
        if(copy_from_user(&regs, addr, sizeof(regs)))
            return -EFAULT;
        return at_priv_dump_dregs(adapter, &regs, addr);
    }
    case LNX_CMD_READ_CFG_REG:
    {
        at_read_cfg_reg reg;
        if(copy_from_user(&reg, addr, sizeof(reg)))
            return -EFAULT;
          
        pci_read_config_dword(
            adapter->pdev,
            reg.reg,
            &reg.data);
        if(copy_to_user(addr, &reg, sizeof(reg)))
            return -EFAULT;
        return 0;
    }
    case LNX_CMD_WRITE_CFG_REG:
    {
        at_write_cfg_reg reg;
        uint32_t data;
        if(copy_from_user(&reg, addr, sizeof(reg)))
            return  -EFAULT;
        if (reg.mask == 0xffffffff) {
            data = reg.data;
        } else {
            pci_read_config_dword(
                adapter->pdev,
                reg.reg,
                &data);
            data = (data&~reg.mask) | (reg.data&reg.mask);
        }
    pci_write_config_dword(
           adapter->pdev,
           reg.reg,
           data);
    return 0;
    }
    default:
        return -EFAULT;
    }
}

#endif//SIOCDEVPRIVATE
