/*
Linux Attansic 1 Gigabit Ethernet Driver main header file  
*/

#ifndef _ATTANSIC_H__
#define _ATTANSIC_H__


#include <linux/stddef.h>
#if AUTO
#include <linux/autoconf.h>
#else
#include <linux/config.h>
#endif
#include <linux/module.h>
#include <linux/types.h>
#include <asm/byteorder.h>
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/errno.h>
#include <linux/ioport.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/delay.h>
#include <linux/timer.h>
#include <linux/slab.h>
#include <linux/vmalloc.h>
#include <linux/interrupt.h>
#include <linux/string.h>
#include <linux/pagemap.h>
#include <asm/bitops.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <linux/capability.h>
#include <linux/in.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/udp.h>
#include <net/pkt_sched.h>
#include <linux/list.h>
#include <linux/reboot.h>
#ifdef SIOCGMIIPHY
#include <linux/mii.h>
#endif
#ifdef NETIF_F_HW_VLAN_TX
#include <linux/if_vlan.h>
#endif

#define BAR_0   0
#define BAR_1   1
#define BAR_5   5
#define PCI_DMA_64BIT   0xffffffffffffffffULL
#define PCI_DMA_32BIT   0x00000000ffffffffULL

#define LBYTESWAP( a )  ( ( ( (a) & 0x00ff00ff ) << 8 ) | ( ( (a) & 0xff00ff00 ) >> 8 ) )
#define LONGSWAP( a )   ( ( LBYTESWAP( a ) << 16 ) | ( LBYTESWAP( a ) >> 16 ) )
#define SHORTSWAP( a )  ( ( (a) << 8 ) | ( (a) >> 8 ) )

#include "kcompat.h"


#define ATTANSIC_ETHERNET_DEVICE(device_id) {\
    PCI_DEVICE(0x1969, device_id)}
    
    
struct at_adapter;

#include "at_hw.h"

#if DBG
#define AT_DBG(args...) printk(KERN_DEBUG "attansic: " args)
#else
#define AT_DBG(args...)
#endif

#define AT_ERR(args...) printk(KERN_ERR "attansic: " args)


struct at_ring_header {
    /* pointer to the descriptor ring memory */
    void *desc;
    /* physical adress of the descriptor ring */
    dma_addr_t dma;
    /* length of descriptor ring in bytes */
    unsigned int size;
};

/* board specific private data structure */
          
#define AT_REGS_LEN 8
struct at_adapter {
    /* OS defined structs */
    struct net_device *netdev;
    struct pci_dev *pdev;
    struct net_device_stats net_stats;
    
#ifdef NETIF_F_HW_VLAN_TX
    struct vlan_group *vlgrp;//
#endif
    uint32_t wol;
    uint16_t link_speed;
    uint16_t link_duplex;
    spinlock_t stats_lock;
    spinlock_t tx_lock;
    atomic_t irq_sem;//
    struct work_struct tx_timeout_task;//
    struct work_struct link_chg_task;//
    struct work_struct pcie_dma_to_rst_task;
    struct timer_list watchdog_timer;
    struct timer_list phy_config_timer;
    boolean_t phy_timer_pending;

    boolean_t mac_disabled;


    // All Descriptor memory
    dma_addr_t  ring_dma;
    void*               ring_vir_addr;
    int                 ring_size;
    
    tx_pkt_header_t* txd_ring;
    dma_addr_t           txd_dma;
    
    tx_pkt_status_t* txs_ring;
    dma_addr_t           txs_dma;
    
    rx_desc_t*           rxd_ring;
    dma_addr_t       rxd_dma;
    
    uint32_t txd_ring_size;         // bytes per unit
    uint32_t txs_ring_size;         // dwords per unit
    uint32_t rxd_ring_size;         // 1536bytes per unit

    // read /write ptr:
    // host
    uint32_t txd_write_ptr;
    uint32_t txs_next_clear;
    uint32_t rxd_read_ptr;
    
    // nic
    atomic_t txd_read_ptr;
    atomic_t txs_write_ptr;
    uint32_t rxd_write_ptr;
    
    
    /* Interrupt Moderator timer ( 2us resolution) */
    uint16_t imt;
    /* Interrupt Clear timer (2us resolution) */
    uint16_t ict;
    

    /* structs defined in at_hw.h */
    uint32_t bd_number;     // board number;
    boolean_t pci_using_64;
    struct at_hw hw;

    uint32_t usr_cmd;
    uint32_t regs_buff[AT_REGS_LEN];
    uint32_t pci_state[16];
};




#endif//_ATTANSIC_H__
