/* ANSI-C code produced by gperf version 2.7.2 */
/* Command-line: gperf -t -L ANSI-C -H aliases_hash -N aliases_lookup -G -W aliases -7 -C -k '1,3-11,$' -i 1 lib/aliases.gperf  */
struct alias { const char* name; unsigned int encoding_index; };

#define TOTAL_KEYWORDS 312
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 45
#define MIN_HASH_VALUE 8
#define MAX_HASH_VALUE 2525
/* maximum key range = 2518, duplicates = 0 */

#ifdef __GNUC__
__inline
#else
#ifdef __cplusplus
inline
#endif
#endif
static unsigned int
aliases_hash (register const char *str, register unsigned int len)
{
  static const unsigned short asso_values[] =
    {
      2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526,
      2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526,
      2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526,
      2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526,
      2526, 2526, 2526, 2526, 2526,    1,   36, 2526,   11,  321,
        66,   51,  221,  146,  376,  176,    1,   81,   71, 2526,
      2526, 2526, 2526, 2526, 2526,   66,   36,  441,   11,    1,
       391,  471,  311,    1,    1,   26,  280,  101,    6,    1,
        16, 2526,   81,    1,    1,  226,    6,  161,  491,    6,
         1, 2526, 2526, 2526, 2526,   36, 2526, 2526, 2526, 2526,
      2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526,
      2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526,
      2526, 2526, 2526, 2526, 2526, 2526, 2526, 2526
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 11:
        hval += asso_values[(unsigned char) str[10]];
      case 10:
        hval += asso_values[(unsigned char) str[9]];
      case 9:
        hval += asso_values[(unsigned char) str[8]];
      case 8:
        hval += asso_values[(unsigned char) str[7]];
      case 7:
        hval += asso_values[(unsigned char) str[6]];
      case 6:
        hval += asso_values[(unsigned char) str[5]];
      case 5:
        hval += asso_values[(unsigned char) str[4]];
      case 4:
        hval += asso_values[(unsigned char) str[3]];
      case 3:
        hval += asso_values[(unsigned char) str[2]];
      case 2:
      case 1:
        hval += asso_values[(unsigned char) str[0]];
        break;
    }
  return hval + asso_values[(unsigned char) str[len - 1]];
}

static const struct alias aliases[] =
  {
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"SJIS", ei_sjis},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""},
    {"JP", ei_iso646_jp},
    {""}, {""}, {""},
    {"TCVN", ei_tcvn},
    {""}, {""},
    {"850", ei_cp850},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""},
    {"KOI8-T", ei_koi8_t},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""},
    {"R8", ei_hp_roman8},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""},
    {"JIS0208", ei_jisx0208},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""},
    {"MS-EE", ei_cp1250},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"862", ei_cp862},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"JAVA", ei_java},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""},
    {"MS-ANSI", ei_cp1252},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"KOREAN", ei_ksc5601},
    {""}, {""}, {""},
    {"ELOT_928", ei_iso8859_7},
    {"KOI8-R", ei_koi8_r},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""},
    {"US", ei_ascii},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""},
    {"ISO-IR-58", ei_gb2312},
    {""},
    {"ISO-8859-8", ei_iso8859_8},
    {"MS_KANJI", ei_sjis},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""},
    {"ISO-2022-JP", ei_iso2022_jp},
    {""}, {""}, {""}, {""},
    {"ROMAN8", ei_hp_roman8},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""},
    {"ISO-IR-203", ei_iso8859_15},
    {""},
    {"IBM850", ei_cp850},
    {""}, {""},
    {"ISO_8859-8", ei_iso8859_8},
    {""}, {""},
    {"L8", ei_iso8859_14},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""},
    {"LATIN8", ei_iso8859_14},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""},
    {"ISO-2022-JP-2", ei_iso2022_jp2},
    {""}, {""}, {""}, {""},
    {"HZ", ei_hz},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"L3", ei_iso8859_3},
    {""}, {""}, {""}, {""}, {""},
    {"UCS-2BE", ei_ucs2be},
    {""}, {""}, {""}, {""}, {""},
    {"ISO-8859-3", ei_iso8859_3},
    {"EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", ei_euc_jp},
    {""},
    {"L2", ei_iso8859_2},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"ISO_8859-8:1988", ei_iso8859_8},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"UCS-2", ei_ucs2},
    {"ASMO-708", ei_iso8859_6},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"ISO-8859-2", ei_iso8859_2},
    {""}, {""}, {""}, {""},
    {"ISO_8859-3", ei_iso8859_3},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""},
    {"MS-ARAB", ei_cp1256},
    {""},
    {"LATIN3", ei_iso8859_3},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"ISO-8859-9", ei_iso8859_9},
    {"ISO_8859-3:1988", ei_iso8859_3},
    {""},
    {"SHIFT-JIS", ei_sjis},
    {""},
    {"ISO_8859-2", ei_iso8859_2},
    {""},
    {"ISO-2022-KR", ei_iso2022_kr},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""},
    {"LATIN2", ei_iso8859_2},
    {""},
    {"L5", ei_iso8859_9},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""},
    {"ISO_8859-9", ei_iso8859_9},
    {""}, {""},
    {"SHIFT_JIS", ei_sjis},
    {""}, {""}, {""}, {""},
    {"ISO-IR-87", ei_jisx0208},
    {"CN", ei_iso646_cn},
    {"ISO-IR-100", ei_iso8859_1},
    {""}, {""}, {""}, {""},
    {"JOHAB", ei_johab},
    {""},
    {"VISCII", ei_viscii},
    {"L7", ei_iso8859_13},
    {"CHINESE", ei_gb2312},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"MS-TURK", ei_cp1254},
    {"ISO-IR-138", ei_iso8859_8},
    {""},
    {"TIS620", ei_tis620},
    {""},
    {"TIS-620", ei_tis620},
    {""}, {""}, {""}, {""}, {""},
    {"EUCJP", ei_euc_jp},
    {""},
    {"EUC-JP", ei_euc_jp},
    {""}, {""}, {""},
    {"TIS620-0", ei_tis620},
    {"KOI8-U", ei_koi8_u},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"UCS-4BE", ei_ucs4be},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"ISO_8859-5:1988", ei_iso8859_5},
    {""},
    {"L4", ei_iso8859_4},
    {""}, {""}, {""},
    {"GREEK8", ei_iso8859_7},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"ASCII", ei_ascii},
    {"ISO_8859-9:1989", ei_iso8859_9},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"GBK", ei_ces_gbk},
    {""}, {""}, {""},
    {"GREEK", ei_iso8859_7},
    {""}, {""}, {""}, {""},
    {"ISO-8859-5", ei_iso8859_5},
    {""}, {""}, {""}, {""}, {""},
    {"NEXTSTEP", ei_nextstep},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""},
    {"ISO-2022-JP-1", ei_iso2022_jp1},
    {""}, {""}, {""}, {""},
    {"KOI8-RU", ei_koi8_ru},
    {"ISO_8859-5", ei_iso8859_5},
    {"EUCJP-MS", ei_eucjp_ms},
    {""}, {""}, {""},
    {"X0208", ei_jisx0208},
    {"ISO_8859-4:1988", ei_iso8859_4},
    {""},
    {"HP-ROMAN8", ei_hp_roman8},
    {"UCS-2-SWAPPED", ei_ucs2swapped},
    {""}, {""}, {""},
    {"UCS-2LE", ei_ucs2le},
    {""}, {""},
    {"LATIN5", ei_iso8859_9},
    {"ISO-8859-10", ei_iso8859_10},
    {""}, {""},
    {"ISO-IR-109", ei_iso8859_3},
    {""},
    {"IBM819", ei_iso8859_1},
    {"ISO-IR-57", ei_iso646_cn},
    {""},
    {"ISO-8859-7", ei_iso8859_7},
    {"ISO_8859-2:1987", ei_iso8859_2},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"L1", ei_iso8859_1},
    {""}, {""},
    {"C99", ei_c99},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"CP850", ei_cp850},
    {""},
    {"IBM862", ei_cp862},
    {""},
    {"MS-HEBR", ei_cp1255},
    {""}, {""},
    {"ISO_8859-10", ei_iso8859_10},
    {"ARMSCII-8", ei_armscii_8},
    {""},
    {"UTF-8", ei_utf8},
    {""}, {""},
    {"JIS_X0208", ei_jisx0208},
    {""},
    {"ISO_8859-7", ei_iso8859_7},
    {""}, {""}, {""}, {""},
    {"EUCKR", ei_euc_kr},
    {""},
    {"EUC-KR", ei_euc_kr},
    {""},
    {"CSKOI8R", ei_koi8_r},
    {"ISO-IR-148", ei_iso8859_9},
    {""}, {""}, {""}, {""}, {""},
    {"LATIN7", ei_iso8859_13},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""},
    {"L6", ei_iso8859_10},
    {""},
    {"ISO-IR-199", ei_iso8859_14},
    {""}, {""}, {""},
    {"WCHAR_T", ei_local_wchar_t},
    {""}, {""},
    {"ISO-8859-13", ei_iso8859_13},
    {""}, {""}, {""}, {""}, {""},
    {"CHAR", ei_local_char},
    {""},
    {"UCS-4", ei_ucs4},
    {"ISO-2022-CN-EXT", ei_iso2022_cn_ext},
    {"ISO-2022-CN", ei_iso2022_cn},
    {""},
    {"UCS-2-INTERNAL", ei_ucs2internal},
    {""}, {""},
    {"ISO_8859-10:1992", ei_iso8859_10},
    {""}, {""},
    {"ISO-8859-4", ei_iso8859_4},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"CP950", ei_cp950},
    {""},
    {"CSISO2022JP", ei_iso2022_jp},
    {""}, {""}, {""}, {""},
    {"ISO_8859-13", ei_iso8859_13},
    {""}, {""}, {""},
    {"ISO_8859-7:1987", ei_iso8859_7},
    {""}, {""}, {""},
    {"CP932", ei_cp932},
    {""}, {""}, {""}, {""}, {""},
    {"MS-GREEK", ei_cp1253},
    {""}, {""}, {""},
    {"ISO_8859-4", ei_iso8859_4},
    {""}, {""}, {""}, {""},
    {"ISO-IR-159", ei_jisx0212},
    {""},
    {"WINDOWS-31J", ei_cp932},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"UCS-4-SWAPPED", ei_ucs4swapped},
    {""},
    {"LATIN4", ei_iso8859_4},
    {""},
    {"UCS-4LE", ei_ucs4le},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"US-ASCII", ei_ascii},
    {""},
    {"CSISO2022JP2", ei_iso2022_jp2},
    {""}, {""}, {""},
    {"ISO_8859-15:1998", ei_iso8859_15},
    {""}, {""},
    {"ISO-IR-179", ei_iso8859_13},
    {"866", ei_cp866},
    {"HEBREW", ei_iso8859_8},
    {""}, {""},
    {"ISO-IR-110", ei_iso8859_4},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"EUCTW", ei_euc_tw},
    {""},
    {"EUC-TW", ei_euc_tw},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"UTF-32BE", ei_utf32be},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"TCVN-5712", ei_tcvn},
    {""},
    {"ISO-IR-149", ei_ksc5601},
    {""}, {""},
    {"BIG5", ei_ces_big5},
    {""},
    {"BIG-5", ei_ces_big5},
    {""},
    {"UTF-32", ei_utf32},
    {""}, {""}, {""},
    {"MACROMAN", ei_mac_roman},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"ECMA-118", ei_iso8859_7},
    {""}, {""}, {""}, {""}, {""},
    {"ISO_8859-14:1998", ei_iso8859_14},
    {""},
    {"TIS620.2533-0", ei_tis620},
    {""}, {""}, {""}, {""},
    {"UCS-4-INTERNAL", ei_ucs4internal},
    {"ISO-IR-127", ei_iso8859_6},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"WINBALTRIM", ei_cp1257},
    {""},
    {"ISO-IR-6", ei_ascii},
    {""}, {""}, {""}, {""},
    {"ISO_8859-1:1987", ei_iso8859_1},
    {"CSISO2022KR", ei_iso2022_kr},
    {""}, {""}, {""}, {""},
    {"ISO-8859-15", ei_iso8859_15},
    {"ISO-IR-14", ei_iso646_jp},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"GB18030", ei_gb18030},
    {"ISO-8859-1", ei_iso8859_1},
    {""},
    {"IBM367", ei_ascii},
    {"WINDOWS-1258", ei_cp1258},
    {""}, {""}, {""},
    {"ISO_8859-15", ei_iso8859_15},
    {""}, {""}, {""}, {""}, {""},
    {"WINDOWS-1250", ei_cp1250},
    {""},
    {"EUCCN", ei_euc_cn},
    {"CSVISCII", ei_viscii},
    {"EUC-CN", ei_euc_cn},
    {""}, {""}, {""},
    {"ISO_8859-6:1987", ei_iso8859_6},
    {""}, {""}, {""},
    {"CP949", ei_cp949},
    {"CSISOLATIN3", ei_iso8859_3},
    {""}, {""},
    {"BIGFIVE", ei_ces_big5},
    {"ISO-IR-157", ei_iso8859_10},
    {"BIG-FIVE", ei_ces_big5},
    {""}, {""}, {""},
    {"ISO_8859-1", ei_iso8859_1},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"MACTHAI", ei_mac_thai},
    {"CP819", ei_iso8859_1},
    {""}, {""}, {""}, {""}, {""},
    {"LATIN1", ei_iso8859_1},
    {""},
    {"WINDOWS-1253", ei_cp1253},
    {""},
    {"MACROMANIA", ei_mac_romania},
    {"CSISOLATIN2", ei_iso8859_2},
    {""}, {""}, {""},
    {"GB_1988-80", ei_iso646_cn},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"WINDOWS-1252", ei_cp1252},
    {""},
    {"CP862", ei_cp862},
    {""}, {""}, {""},
    {"CSASCII", ei_ascii},
    {"MACUKRAINE", ei_mac_ukraine},
    {""}, {""}, {""}, {""},
    {"JIS_X0208-1990", ei_jisx0208},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"WINDOWS-874", ei_cp874},
    {""}, {""},
    {"UTF-7", ei_utf7},
    {""}, {""},
    {"UNICODELITTLE", ei_ucs2le},
    {""},
    {"ISO-IR-226", ei_iso8859_16},
    {""},
    {"CP1258", ei_cp1258},
    {""}, {""}, {""},
    {"MAC", ei_mac_roman},
    {""}, {""}, {""},
    {"CN-GB", ei_euc_cn},
    {""},
    {"ISO_8859-16:2000", ei_iso8859_16},
    {""}, {""},
    {"ISO-8859-6", ei_iso8859_6},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"CP1250", ei_cp1250},
    {""}, {""},
    {"JIS_X0208-1983", ei_jisx0208},
    {""},
    {"ISO-8859-14", ei_iso8859_14},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"X0212", ei_jisx0212},
    {""}, {""},
    {"ISO646-JP", ei_iso646_jp},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"UTF-32LE", ei_utf32le},
    {"CSISO159JISX02121990", ei_jisx0212},
    {""}, {""}, {""},
    {"ISO_8859-6", ei_iso8859_6},
    {""}, {""},
    {"WINDOWS-1255", ei_cp1255},
    {""},
    {"CSHPROMAN8", ei_hp_roman8},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"ISO_8859-14", ei_iso8859_14},
    {""}, {""},
    {"GB_2312-80", ei_gb2312},
    {"LATIN6", ei_iso8859_10},
    {"GB2312", ei_euc_cn},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"ARABIC", ei_iso8859_6},
    {""}, {""}, {""}, {""}, {""},
    {"WINDOWS-1257", ei_cp1257},
    {""},
    {"CP874", ei_cp874},
    {""}, {""},
    {"JIS_X0212", ei_jisx0212},
    {""},
    {"ISO-IR-101", ei_iso8859_2},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"ISO-IR-144", ei_iso8859_5},
    {""},
    {"CP1253", ei_cp1253},
    {""}, {""},
    {"ISO-IR-165", ei_isoir165},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"CSISOLATIN5", ei_iso8859_9},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"WINDOWS-1254", ei_cp1254},
    {""}, {""},
    {"UHC", ei_cp949},
    {"CP1252", ei_cp1252},
    {""}, {""}, {""}, {""},
    {"CSISO2022CN", ei_iso2022_cn},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"GEORGIAN-PS", ei_georgian_ps},
    {""}, {""}, {""},
    {"CSISO87JISX0208", ei_jisx0208},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"CSUNICODE", ei_ucs2},
    {"TIS620.2533-1", ei_tis620},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"MACGREEK", ei_mac_greek},
    {""}, {""}, {""},
    {"CSSHIFTJIS", ei_sjis},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""},
    {"TCVN5712-1:1993", ei_tcvn},
    {""},
    {"MACINTOSH", ei_mac_roman},
    {"TIS620.2529-1", ei_tis620},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""},
    {"CN-GB-ISOIR165", ei_isoir165},
    {""},
    {"MS-CYRL", ei_cp1251},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""},
    {"WINDOWS-1251", ei_cp1251},
    {""}, {""}, {""}, {""},
    {"ISO646-US", ei_ascii},
    {""},
    {"X0201", ei_jisx0201},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"MACCROATIAN", ei_mac_croatian},
    {""}, {""},
    {"CP367", ei_ascii},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"ISO-IR-126", ei_iso8859_7},
    {""},
    {"IBM866", ei_cp866},
    {""}, {""},
    {"ANSI_X3.4-1968", ei_ascii},
    {"CSISO58GB231280", ei_gb2312},
    {"CP1133", ei_cp1133},
    {""}, {""}, {""}, {""},
    {"CSBIG5", ei_ces_big5},
    {""},
    {"CN-BIG5", ei_ces_big5},
    {""},
    {"CSISOLATIN4", ei_iso8859_4},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"ECMA-114", ei_iso8859_6},
    {""},
    {"WINDOWS-1256", ei_cp1256},
    {""}, {""}, {""}, {""},
    {"JIS_X0201", ei_jisx0201},
    {""}, {""}, {""},
    {"CP1255", ei_cp1255},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""},
    {"CSISOLATINHEBREW", ei_iso8859_8},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"MACHEBREW", ei_mac_hebrew},
    {"CSEUCKR", ei_euc_kr},
    {""}, {""}, {""}, {""}, {""},
    {"CSISOLATINGREEK", ei_iso8859_7},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"ISO-8859-16", ei_iso8859_16},
    {""}, {""}, {""},
    {"CSISOLATINARABIC", ei_iso8859_6},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"CP936", ei_ces_gbk},
    {""},
    {"CP1257", ei_cp1257},
    {""}, {""}, {""}, {""}, {""},
    {"JIS_C6220-1969-RO", ei_iso646_jp},
    {""},
    {"JIS_X0212-1990", ei_jisx0212},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""},
    {"ISO_8859-16", ei_iso8859_16},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"UTF-16BE", ei_utf16be},
    {""}, {""}, {""},
    {"IBM-CP1133", ei_cp1133},
    {""}, {""}, {""},
    {"MACICELAND", ei_mac_iceland},
    {""}, {""}, {""}, {""}, {""},
    {"TCVN5712-1", ei_tcvn},
    {""},
    {"JIS_X0212.1990-0", ei_jisx0212},
    {""}, {""}, {""},
    {"MULELAO-1", ei_mulelao},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"HZ-GB-2312", ei_hz},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""},
    {"CP1254", ei_cp1254},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""},
    {"MACCENTRALEUROPE", ei_mac_centraleurope},
    {""},
    {"ISO646-CN", ei_iso646_cn},
    {"CSEUCTW", ei_euc_tw},
    {""}, {""}, {""},
    {"BIG5HKSCS", ei_big5hkscs},
    {""},
    {"BIG5-HKSCS", ei_big5hkscs},
    {""}, {""},
    {"CSISO14JISC6220RO", ei_iso646_jp},
    {""}, {""},
    {"CSISOLATIN1", ei_iso8859_1},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""},
    {"ISO_646.IRV:1991", ei_ascii},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""},
    {"MACTURKISH", ei_mac_turkish},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"UNICODE-1-1-UTF-7", ei_utf7},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"CSGB2312", ei_euc_cn},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"ISO-IR-166", ei_tis620},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""},
    {"CSUCS4", ei_ucs4},
    {""}, {""}, {""},
    {"CSISOLATIN6", ei_iso8859_10},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""},
    {"CP866", ei_cp866},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""},
    {"UTF-16LE", ei_utf16le},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"ANSI_X3.4-1986", ei_ascii},
    {"ISO-10646-UCS-2", ei_ucs2},
    {""}, {""},
    {"ISO-CELTIC", ei_iso8859_14},
    {""}, {""},
    {"CP1251", ei_cp1251},
    {""}, {""}, {""}, {""},
    {"GEORGIAN-ACADEMY", ei_georgian_academy},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""},
    {"UNICODE-1-1", ei_ucs2be},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""},
    {"UNICODEBIG", ei_ucs2be},
    {""}, {""}, {""}, {""},
    {"CSEUCPKDFMTJAPANESE", ei_euc_jp},
    {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"MACARABIC", ei_mac_arabic},
    {""}, {""},
    {"KSC_5601", ei_ksc5601},
    {""}, {""},
    {"CSISO57GB1988", ei_iso646_cn},
    {""}, {""},
    {"CSMACINTOSH", ei_mac_roman},
    {""},
    {"JISX0201-1976", ei_jisx0201},
    {""}, {""},
    {"UTF-16", ei_utf16},
    {"CSISOLATINCYRILLIC", ei_iso8859_5},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"CSIBM866", ei_cp866},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"CP1256", ei_cp1256},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"JIS_C6226-1983", ei_jisx0208},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""},
    {"ISO-10646-UCS-4", ei_ucs4},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""},
    {"VISCII1.1-1", ei_viscii},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"KS_C_5601-1989", ei_ksc5601},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"CP1361", ei_johab},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""},
    {"CSPC862LATINHEBREW", ei_cp862},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"KS_C_5601-1987", ei_ksc5601},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""},
    {"CSUNICODE11UTF7", ei_utf7},
    {""},
    {"CSPC850MULTILINGUAL", ei_cp850},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""},
    {"CYRILLIC", ei_iso8859_5},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""},
    {"CSHALFWIDTHKATAKANA", ei_jisx0201},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""},
    {"CSUNICODE11", ei_ucs2be},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"CSKSC56011987", ei_ksc5601},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
    {"MACCYRILLIC", ei_mac_cyrillic}
  };

#ifdef __GNUC__
__inline
#endif
const struct alias *
aliases_lookup (register const char *str, register unsigned int len)
{
  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = aliases_hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register const char *s = aliases[key].name;

          if (*str == *s && !strcmp (str + 1, s + 1))
            return &aliases[key];
        }
    }
  return 0;
}
