/* sem.h
 * Semaphore utility
 *
 *---------------------------------------------------------------------------
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
 *---------------------------------------------------------------------------
 *
 *  system: SA1200
 *  subsystem: Common
 * Author: Intel Corporation
 */
#ifndef __SEM_H
#define __SEM_H

enum{SEM_SUCCESS=0, SEM_FAILED, SEM_TIMEDOUT};
typedef void *sem_T;
#define SEM_WAITFOREVER 0xffffffff

#ifdef __cplusplus
extern "C" {
#endif
sem_T Sem_Init(unsigned int initCount);
int Sem_Destroy(sem_T sem);
int Sem_Post(sem_T sem);
int Sem_Wait(sem_T sem, unsigned int timeout);
#ifdef __cplusplus
}
#endif


#endif /* __SEM_H */
