/**
 * @file IxEthAccDataPlane_p.h
 *
 * @author Intel Corporation
 * @date 12-Feb-2002
 *
 * @brief  Internal Header file for IXP425 Ethernet Access component.
 *
 * Design Notes:
 *
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 */



#ifndef IxEthAccDataPlane_p_H
#define IxEthAccDataPlane_p_H

#include <IxOsServices.h>
#include <IxOsBuffMgt.h>
#include <IxQMgr.h>

/**
 * @addtogroup IxEthAccPri
 *@{
 */

/* typedefs global to this file*/

typedef struct
{
    IX_MBUF *pHead;
    IX_MBUF *pTail;
}IxEthAccDataPlaneQList;


/**
 * @struct  IxEthAccDataPlaneStats
 * @brief   Statistics data structure associated with the data plane
 *
 */
typedef struct
{
    UINT32 addToSwQ;
    UINT32 removeFromSwQ;
    UINT32 unchainedTxMBufs;
    UINT32 chainedTxMBufs;
    UINT32 unchainedTxDoneMBufs;
    UINT32 chainedTxDoneMBufs;
    UINT32 unchainedRxMBufs;
    UINT32 chainedRxMBufs;
    UINT32 unchainedRxFreeMBufs;
    UINT32 chainedRxFreeMBufs;
    UINT32 rxCallbackCounter;
    UINT32 txDoneCallbackCounter;
    UINT32 unexpectedError;
}IxEthAccDataPlaneStats;

/**
 * @fn ixEthAccMbufFromSwQ
 * @brief  used during disable steps to convert mbufs from 
 *  swq format, ready to be pushed into hw queues for NPE, 
 *  back into XScale format 
 */
IX_MBUF *ixEthAccMbufFromSwQ(IX_MBUF *mbuf);

/**
 * @fn ixEthAccDataPlaneShow
 * @brief  Show function (for data plane statistics
 */
void ixEthAccDataPlaneShow(void);

#define IX_ETH_ACC_DATA_PLANE_LOCK(arg) arg = ixOsServIntLock();
#define IX_ETH_ACC_DATA_PLANE_UNLOCK(arg) ixOsServIntUnlock(arg);

/*
 * Use MBUF  next pointer field to chain data.
 */
#define IX_ETH_ACC_MBUF_NEXT_PKT_CHAIN_MEMBER(mbuf) IX_MBUF_NEXT_PKT_IN_CHAIN_PTR(mbuf)



#define IX_ETH_ACC_DATAPLANE_IS_Q_EMPTY(mbuf_list) ((mbuf_list.pHead) == NULL)
    

#define IX_ETH_ACC_DATAPLANE_ADD_MBUF_TO_Q_HEAD(mbuf_list,mbuf_to_add) 		\
  do {										\
    int lockVal;								\
    IX_ETH_ACC_DATA_PLANE_LOCK(lockVal);                                    	\
    IX_ETH_ACC_STATS_INC(ixEthAccDataStats.addToSwQ);                           \
    if ( (mbuf_list.pHead) != NULL ) 						\
    {										\
      (IX_ETH_ACC_MBUF_NEXT_PKT_CHAIN_MEMBER((mbuf_to_add))) = (mbuf_list.pHead);\
      (mbuf_list.pHead) = (mbuf_to_add);					\
    } 										\
    else {									\
      (mbuf_list.pTail) = (mbuf_list.pHead) = (mbuf_to_add);			\
      IX_ETH_ACC_MBUF_NEXT_PKT_CHAIN_MEMBER((mbuf_to_add)) = NULL;		\
    } 										\
    IX_ETH_ACC_DATA_PLANE_UNLOCK(lockVal);					\
  } while(0)


#define IX_ETH_ACC_DATAPLANE_ADD_MBUF_TO_Q_TAIL(mbuf_list,mbuf_to_add)   	\
  do {										\
    int lockVal;								\
    IX_ETH_ACC_DATA_PLANE_LOCK(lockVal);                                    	\
    IX_ETH_ACC_STATS_INC(ixEthAccDataStats.addToSwQ);                           \
    if ( (mbuf_list.pHead) == NULL ) 						\
    {										\
      (mbuf_list.pHead) = mbuf_to_add;						\
      IX_ETH_ACC_MBUF_NEXT_PKT_CHAIN_MEMBER((mbuf_to_add)) = NULL;		\
    } 										\
    else {									\
      IX_ETH_ACC_MBUF_NEXT_PKT_CHAIN_MEMBER((mbuf_list.pTail)) = (mbuf_to_add);	\
      IX_ETH_ACC_MBUF_NEXT_PKT_CHAIN_MEMBER((mbuf_to_add)) = NULL;		\
    } 										\
    (mbuf_list.pTail) = mbuf_to_add;						\
    IX_ETH_ACC_DATA_PLANE_UNLOCK(lockVal);					\
  } while (0)


#define IX_ETH_ACC_DATAPLANE_REMOVE_MBUF_FROM_Q_HEAD(mbuf_list,mbuf_to_rem)   	\
  do {										\
    int lockVal;								\
    IX_ETH_ACC_DATA_PLANE_LOCK(lockVal);                                    	\
    if ( (mbuf_list.pHead) != NULL ) 						\
    {										\
      IX_ETH_ACC_STATS_INC(ixEthAccDataStats.removeFromSwQ);                    \
      (mbuf_to_rem) = (mbuf_list.pHead) ;					\
      (mbuf_list.pHead) = (IX_ETH_ACC_MBUF_NEXT_PKT_CHAIN_MEMBER((mbuf_to_rem)));\
    } 										\
    else {									\
      (mbuf_to_rem) = NULL;							\
    } 										\
    IX_ETH_ACC_DATA_PLANE_UNLOCK(lockVal);					\
  } while (0)


/**
 * @brief message handler QManager enties for NPE id => port ID conversion (NPE_B => 0, NPE_C => 1)
 */
#define IX_ETH_ACC_QM_NPE_ID_TO_PORT_ID(npe) (npe) 

#define IX_ETH_ACC_PORT_TO_TX_Q_ID(port)    (port == IX_ETH_PORT_1 ? IX_ETH_ACC_TX_FRAME_ENET0_Q : IX_ETH_ACC_TX_FRAME_ENET1_Q)

#define IX_ETH_ACC_PORT_TO_TX_Q_SOURCE(port)    (port == IX_ETH_PORT_1 ? IX_ETH_ACC_TX_FRAME_ENET0_Q_SOURCE : IX_ETH_ACC_TX_FRAME_ENET1_Q_SOURCE)

#define IX_ETH_ACC_PORT_TO_RX_FREE_Q_ID(port) (port == IX_ETH_PORT_1 ? IX_ETH_ACC_RX_FREE_BUFF_ENET0_Q : IX_ETH_ACC_RX_FREE_BUFF_ENET1_Q)

#define IX_ETH_ACC_PORT_TO_RX_FREE_Q_SOURCE(port) (port == IX_ETH_PORT_1 ? IX_ETH_ACC_RX_FREE_BUFF_ENET0_Q_SOURCE : IX_ETH_ACC_RX_FREE_BUFF_ENET1_Q_SOURCE)

/* Flush the mbufs chain and all data pointed to by the mbuf */

#define IX_ETH_ACC_FLUSH_MBUF_AND_DATA(mbuf_arg)  					\
{ 											\
	IX_MBUF *mbufPtr = (mbuf_arg);							\
	while(mbufPtr) 									\
	{										\
	    IX_ACC_DATA_CACHE_FLUSH((mbufPtr),sizeof(IX_MBUF))				\
	    IX_ACC_DATA_CACHE_FLUSH(IX_MBUF_MDATA(mbufPtr),IX_MBUF_MLEN(mbufPtr))	\
	    mbufPtr = IX_MBUF_NEXT_BUFFER_IN_PKT_PTR(mbufPtr);				\
	}										\
} 

#ifndef NDEBUG
#define IX_ETH_ACC_STATS_INC(x) (x++)
#else
#define IX_ETH_ACC_STATS_INC(x)
#endif

#define IX_ETH_ACC_MAX_TX_FRAMES_TO_SUBMIT 128

void  ixEthAccRecoverRxFreeQBuffers(IxEthAccPortId portId);
void  ixEthAccRecoverTxSubmittedQBuffers(IxEthAccPortId portId);
void  ixEthAccRecoverSwQBuffers(IxEthAccPortId portId);

void ixEthRxFrameQMCallback(IxQMgrQId qId, IxQMgrCallbackId callbackId);
void ixEthTxFrameDoneQMCallback(IxQMgrQId qId, IxQMgrCallbackId callbackId);

#endif /* IxEthAccDataPlane_p_H */


/**
 *@}
 */

